/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.Projectable;
import com.mysema.query.ResultTransformer;
import com.mysema.query.Tuple;
import com.mysema.query.support.QueryBase;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expression;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ProjectableQuery<Q extends ProjectableQuery<Q>>
extends QueryBase<Q>
implements Projectable {
    public ProjectableQuery(QueryMixin<Q> queryMixin) {
        super(queryMixin);
    }

    @Override
    public List<Tuple> list(Expression<?> ... args) {
        return IteratorAdapter.asList(this.iterate(args));
    }

    @Override
    public <RT> List<RT> list(Expression<RT> projection) {
        return IteratorAdapter.asList(this.iterate(projection));
    }

    @Override
    public final <K, V> Map<K, V> map(Expression<K> key, Expression<V> value) {
        List<Tuple> list = this.list(key, value);
        LinkedHashMap<K, V> results = new LinkedHashMap<K, V>(list.size());
        for (Tuple row : list) {
            results.put(row.get(key), row.get(value));
        }
        return results;
    }

    @Override
    public final boolean notExists() {
        return !this.exists();
    }

    @Override
    public final Tuple singleResult(Expression<?> ... args) {
        return ((ProjectableQuery)this.limit(1L)).uniqueResult(args);
    }

    @Override
    public final <RT> RT singleResult(Expression<RT> expr) {
        return ((ProjectableQuery)this.limit(1L)).uniqueResult(expr);
    }

    @Override
    public <T> T transform(ResultTransformer<T> transformer) {
        return transformer.transform(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected <T> T uniqueResult(CloseableIterator<T> it) {
        try {
            if (it.hasNext()) {
                Object rv = it.next();
                if (it.hasNext()) {
                    throw new NonUniqueResultException();
                }
                Object e = rv;
                return (T)e;
            }
            T t = null;
            return t;
        }
        finally {
            it.close();
        }
    }
}

