/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import java.util.ArrayList;
import java.util.List;
import net.objectlab.kit.datecalc.common.AbstractIMMDateCalculator;
import net.objectlab.kit.datecalc.common.IMMPeriod;
import net.objectlab.kit.datecalc.joda.LocalDateIMMDateCalculator;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YearMonthDayIMMDateCalculator
extends AbstractIMMDateCalculator<YearMonthDay> {
    private static final LocalDateIMMDateCalculator DELEGATE = new LocalDateIMMDateCalculator();

    @Override
    public boolean isIMMDate(YearMonthDay date) {
        return DELEGATE.isIMMDate(date.toLocalDate());
    }

    @Override
    protected YearMonthDay getNextIMMDate(boolean requestNextIMM, YearMonthDay theStartDate, IMMPeriod period) {
        return new YearMonthDay((Object)DELEGATE.getNextIMMDate(requestNextIMM, theStartDate.toLocalDate(), period));
    }

    @Override
    public List<YearMonthDay> getIMMDates(YearMonthDay start, YearMonthDay end, IMMPeriod period) {
        return this.buildList(DELEGATE.getIMMDates(start.toLocalDate(), end.toLocalDate(), period));
    }

    private List<YearMonthDay> buildList(List<LocalDate> dates) {
        ArrayList<YearMonthDay> imms = new ArrayList<YearMonthDay>();
        for (LocalDate date : dates) {
            imms.add(new YearMonthDay((Object)date));
        }
        return imms;
    }
}

