/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.customfields.service;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.pocketknife.api.customfields.service.FieldLockingService;
import com.atlassian.pocketknife.spi.info.PocketKnifePluginInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FieldLockingServiceImpl
implements FieldLockingService {
    private final Logger logger = LoggerFactory.getLogger(FieldLockingServiceImpl.class);
    @Autowired
    PocketKnifePluginInfo pocketKnifeIntegration;
    @Autowired
    private ManagedConfigurationItemService managedConfigurationItemService;

    @Override
    public ErrorCollection lockField(CustomField field, String descI18nKey) {
        this.logger.info("Configuration locked for field {}", (Object)field.getFieldName());
        ManagedConfigurationItem managedConfigurationItem = this.managedConfigurationItemService.getManagedCustomField(field);
        if (this.isLocked(managedConfigurationItem)) {
            return new SimpleErrorCollection();
        }
        String pluginKey = this.pocketKnifeIntegration.getPluginKey();
        ManagedConfigurationItem updatedManagedConfigurationItem = managedConfigurationItem.newBuilder().setManaged(true).setConfigurationItemAccessLevel(ConfigurationItemAccessLevel.LOCKED).setSource(pluginKey + ":field-locking-service").setDescriptionI18nKey(descI18nKey).build();
        ServiceOutcome resultOutcome = this.managedConfigurationItemService.updateManagedConfigurationItem(updatedManagedConfigurationItem);
        this.logger.info("Configuration locked for field {} with {} ", (Object)field.getFieldName(), (Object)resultOutcome.isValid());
        return resultOutcome.getErrorCollection();
    }

    @Override
    public boolean isFieldLocked(CustomField field) {
        return this.isLocked(this.managedConfigurationItemService.getManagedCustomField(field));
    }

    private boolean isLocked(ManagedConfigurationItem managedConfigurationItem) {
        return managedConfigurationItem.isManaged() && managedConfigurationItem.getConfigurationItemAccessLevel() == ConfigurationItemAccessLevel.LOCKED;
    }
}

