/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.link;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.IssueLinkException;
import com.atlassian.rm.common.bridges.jira.issue.IssueLinkValidationException;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridge;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridge812")
@SupportedVersions(all=true)
public class IssueLinkServiceBridge812
implements IssueLinkServiceBridge {
    private final ApplicationProperties applicationProperties;
    private final IssueLinkService issueLinkService;
    private final IssueLinkManager issueLinkManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueService issueService;

    @Autowired
    public IssueLinkServiceBridge812(ApplicationProperties applicationProperties, IssueLinkService issueLinkService, IssueLinkManager issueLinkManager, IssueLinkTypeManager issueLinkTypeManager, IssueService issueService) {
        this.applicationProperties = applicationProperties;
        this.issueLinkService = issueLinkService;
        this.issueLinkManager = issueLinkManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueService = issueService;
    }

    @Override
    public IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(ApplicationUser user, Issue issue, Long issueLinkTypeId, Direction direction, Collection<String> linkKeys, boolean excludeSystemLinks) {
        return this.issueLinkService.validateAddIssueLinks(user, issue, issueLinkTypeId, direction, linkKeys, excludeSystemLinks);
    }

    @Override
    public void addIssueLinks(ApplicationUser user, IssueLinkService.AddIssueLinkValidationResult result) {
        this.issueLinkService.addIssueLinks(user, result);
    }

    @Override
    public IssueLinkService.DeleteIssueLinkValidationResult validateDelete(ApplicationUser user, Issue issue, IssueLink issueLink) {
        return this.issueLinkService.validateDelete(user, issue, issueLink);
    }

    @Override
    public IssueLinkService.IssueLinkResult getIssueLinks(ApplicationUser user, Issue issue) {
        return this.issueLinkService.getIssueLinks(user, issue);
    }

    @Override
    public List<IssueLink> getIssueLinks(ApplicationUser user, Collection<Long> issueLinkIds) {
        ArrayList links = Lists.newArrayList();
        for (long id : issueLinkIds) {
            IssueLinkService.SingleIssueLinkResult issueLink = this.issueLinkService.getIssueLink(Long.valueOf(id), user);
            if (!issueLink.isValid()) continue;
            links.add(issueLink.getIssueLink());
        }
        return links;
    }

    @Override
    public List<IssueLink> getIssueLinksForIssue(long realId) {
        List inwardLinks = this.issueLinkManager.getInwardLinks(Long.valueOf(realId));
        List outwardLinks = this.issueLinkManager.getOutwardLinks(Long.valueOf(realId));
        ArrayList allLinks = Lists.newArrayList();
        allLinks.addAll(inwardLinks);
        allLinks.addAll(outwardLinks);
        return allLinks;
    }

    @Override
    public List<IssueLinkType> getIssueLinkTypes() {
        return Lists.newArrayList((Iterable)this.issueLinkService.getIssueLinkTypes());
    }

    @Override
    public List<IssueLinkType> getIssueLinkTypesIncludingSystemTypes() {
        return Lists.newArrayList((Iterable)this.issueLinkTypeManager.getIssueLinkTypes(false));
    }

    @Override
    public List<Long> getIssueLinkTypeIds() {
        return this.issueLinkService.getIssueLinkTypes().stream().map(IssueLinkType::getId).collect(Collectors.toList());
    }

    @Override
    public boolean isIssueLinkingEnabled() {
        return this.applicationProperties.getOption("jira.option.issuelinking");
    }

    @Override
    public long addIssueLink(ApplicationUser user, long sourceIssueId, long targetIssueId, long issueLinkType) throws IssueLinkException, IssueLinkValidationException {
        try {
            Issue sourceIssue = this.getIssue(user, sourceIssueId);
            Issue targetIssue = this.getIssue(user, targetIssueId);
            IssueLinkService.AddIssueLinkValidationResult validationResult = this.issueLinkService.validateAddIssueLinks(user, sourceIssue, Long.valueOf(issueLinkType), Direction.OUT, (Collection)Lists.newArrayList((Object[])new String[]{targetIssue.getKey()}), false);
            if (!validationResult.isValid()) {
                throw new IssueLinkValidationException(validationResult.getErrorCollection().getErrorMessages());
            }
            this.issueLinkService.addIssueLinks(user, validationResult);
            IssueLink link = this.issueLinkManager.getIssueLink(Long.valueOf(sourceIssueId), Long.valueOf(targetIssueId), Long.valueOf(issueLinkType));
            return link.getId();
        }
        catch (IssueLinkException | IssueLinkValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IssueLinkException(ex);
        }
    }

    @Override
    public boolean deleteIssueLink(ApplicationUser user, long issueLinkId) throws IssueLinkException, IssueLinkValidationException {
        try {
            IssueLinkService.SingleIssueLinkResult issueLink = this.issueLinkService.getIssueLink(Long.valueOf(issueLinkId), user);
            if (!issueLink.isValid()) {
                return false;
            }
            Issue sourceIssue = this.getIssue(user, issueLink.getIssueLink().getSourceId());
            IssueLinkService.DeleteIssueLinkValidationResult validationResult = this.issueLinkService.validateDelete(user, sourceIssue, issueLink.getIssueLink());
            if (!validationResult.isValid()) {
                throw new IssueLinkValidationException(validationResult.getErrorCollection().getErrorMessages());
            }
            this.issueLinkService.delete(validationResult);
            return true;
        }
        catch (IssueLinkException | IssueLinkValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IssueLinkException(ex);
        }
    }

    @Override
    public boolean replaceWithOtherType(ApplicationUser user, long issueLinkId, long issueLinkType) throws IssueLinkException {
        try {
            IssueLinkService.SingleIssueLinkResult issueLink = this.issueLinkService.getIssueLink(Long.valueOf(issueLinkId), user);
            if (!issueLink.isValid()) {
                return false;
            }
            IssueLinkType swapLinkType = this.getTypeForId(issueLinkType);
            this.issueLinkManager.changeIssueLinkType(issueLink.getIssueLink(), swapLinkType, user);
            return true;
        }
        catch (IssueLinkException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IssueLinkException(ex);
        }
    }

    private IssueLinkType getTypeForId(long id) throws IssueLinkException {
        for (IssueLinkType type : this.issueLinkService.getIssueLinkTypes()) {
            if (type.getId() != id) continue;
            return type;
        }
        throw new IssueLinkException("Issue link type for id " + id + " not found");
    }

    private Issue getIssue(ApplicationUser user, long issueId) throws IssueLinkException {
        IssueService.IssueResult sourceIssue = this.issueService.getIssue(user, Long.valueOf(issueId));
        if (!sourceIssue.isValid()) {
            throw new IssueLinkException("Issue not found.");
        }
        return sourceIssue.getIssue();
    }
}

