/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lifecycle;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.lifecycle.PluginStartUpTask;
import com.atlassian.rm.common.bridges.jira.lifecycle.PluginStartUpTaskServiceBridge;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lifecycle.PluginStartUpTaskServiceBridge812")
@SupportedVersions(all=true)
class PluginStartUpTaskServiceBridge812
implements PluginStartUpTaskServiceBridge {
    private static final Log LOGGER = Log.with(PluginStartUpTaskServiceBridge812.class);
    private List<PluginStartUpTask> pluginStartUpTasks = Collections.emptyList();

    PluginStartUpTaskServiceBridge812() {
    }

    @Override
    public void triggerPluginStartUpTasks() {
        LOGGER.debug("triggered start up task execution", new Object[0]);
        for (PluginStartUpTask task : this.pluginStartUpTasks) {
            try {
                LOGGER.debug("Executing start up task '%s'...", task.getDisplayName());
                task.execute();
                LOGGER.info("start up task '%s' finished.", task.getDisplayName());
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error during task '%s'.", task.getDisplayName());
                LOGGER.exception(ex, Log.LogLevel.ERROR);
            }
        }
    }

    @Override
    public void setPluginStartUpTasks(List<PluginStartUpTask> pluginStartUpTasks) {
        this.pluginStartUpTasks = pluginStartUpTasks;
    }
}

