/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lifecycle;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.lifecycle.JiraUpgradeTask;
import com.atlassian.rm.common.bridges.jira.lifecycle.UpgradeTaskServiceBridge;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lifecycle.UpgradeTaskServiceBridge812")
@SupportedVersions(all=true)
class UpgradeTaskServiceBridge812
implements UpgradeTaskServiceBridge {
    private static final Log LOGGER = Log.with(UpgradeTaskServiceBridge812.class);
    private List<JiraUpgradeTask> upgradeTasks = Collections.emptyList();

    UpgradeTaskServiceBridge812() {
    }

    @Override
    public void tryTriggerUpgradeTaskExecution() {
        LOGGER.debug("triggered upgrade task execution", new Object[0]);
        for (JiraUpgradeTask task : this.upgradeTasks) {
            try {
                LOGGER.debug("Executing upgrade task '%s'...", task.getDisplayName());
                task.execute();
                LOGGER.info("upgrade task '%s' finished.", task.getDisplayName());
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error during task '%s'.", task.getDisplayName());
                LOGGER.exception(ex, Log.LogLevel.ERROR);
            }
        }
    }

    @Override
    public void setUpgradeTasks(List<JiraUpgradeTask> upgradeTasks) {
        this.upgradeTasks = upgradeTasks;
    }
}

