/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.function;

import com.atlassian.rm.jpo.scheduling.util.function.IUnboundedStepFunction;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PositiveLinearFunction
implements IUnboundedStepFunction<Float> {
    private final float slope;
    private final float yIntercept;

    public PositiveLinearFunction(float yIntercept, float slope) {
        this.slope = slope;
        this.yIntercept = yIntercept;
    }

    @Override
    public int getLowerSpecificationBound() {
        return 0;
    }

    @Override
    public Float getAt(int x) {
        Preconditions.checkArgument(((double)x >= 0.0 ? 1 : 0) != 0, (Object)"x must be greater or equal 0");
        return Float.valueOf(Math.max(0.0f, this.slope * (float)x + this.yIntercept));
    }

    public boolean isPositiveEnding() {
        return (double)this.slope > 0.0 || (double)this.yIntercept > 0.0 && (double)this.slope == 0.0;
    }
}

