/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.INonWorkingDay;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.AONonWorkingDays;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.sql.NonWorkingDaysSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioNonWorkingDaysPersistence;
import com.radiantminds.roadmap.common.rest.entities.plans.RestNonWorkingDay;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsNonWorkingDaysPersistence
extends AOSortableEntityPersistence<INonWorkingDay, AONonWorkingDays>
implements PortfolioNonWorkingDaysPersistence {
    private final NonWorkingDaysSQL sql;
    private final EntityInfoSQL entityInfoSQL;

    @Autowired
    public PortfolioActiveObjectsNonWorkingDaysPersistence(ActiveObjectsUtilities utils) {
        super(utils, INonWorkingDay.class, AONonWorkingDays.class);
        this.sql = new NonWorkingDaysSQL(utils);
        this.entityInfoSQL = new EntityInfoSQL(utils);
    }

    @Override
    protected void transform(INonWorkingDay source, AONonWorkingDays target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setStartDate(source.getStartDate());
        target.setEndDate(source.getEndDate());
        if (source.getPlan() != null) {
            target.setPlan(source.getPlan());
        }
    }

    @Override
    public EntityInfo getEntityInfo(String id) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(id, AONonWorkingDays.class, new EntityInfoSQL.ParentRelationship[0]);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AONonWorkingDays.class, "w").select().raw("*").from("w").where().col("w", "getAOPlan").eq().numeric(planId);
    }

    @Override
    public List<RestNonWorkingDay> listForPlan(String planId) throws SQLException {
        return this.sql.listForPlan(planId);
    }
}

