/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.sorting;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.DeleteSortAction;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WorkItemSortingSQL
extends BaseAOPersistenceSQL {
    public WorkItemSortingSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public DeleteSortAction reactToChildDeletion(final String id) throws SQLException {
        return this.sql(new IQuery<DeleteSortAction>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").withTable(AOWorkItem.class, "i").withTable(AOWorkItem.class, "p").select().col("w", "aoParent").col("w", "sortOrder").col("w", "orderRangeIdentifier").from("w").leftJoin().table("p").on().colId("p").eq().col("w", "aoParent").where().colId("w").eq().numeric(id).and().raw("(").select().raw("count(*)").from("i").where().col("i", "aoParent").eq().col("w", "aoParent").raw(")").eq().numeric(1).and().col("p", "type").neq().numeric(WorkItems.Types.INITIATIVE);
            }

            @Override
            public DeleteSortAction handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return new DeleteSortAction(BaseAOPersistenceSQL.getString(result, 1), WorkItemSortingSQL.getLong(result, 2), BaseAOPersistenceSQL.getString(result, 3));
                }
                return null;
            }
        });
    }

    public String getIdWithHighestSortOrder(final String planId, final String orderRangeId) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").withTable(AOWorkItem.class, "wInner").select().colId("w").from("w").where().col("w", "sortOrder").eq().raw("(").select().raw("MAX(").col("w", "sortOrder").raw(")").from("w").where().col("w", "orderRangeIdentifier").eq().str(orderRangeId + "-" + planId).raw(")");
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        });
    }

    public String getIdWithHighestSortOrderInEpic(final String epicId) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").withTable(AOWorkItem.class, "wInner").select().colId("w").from("w").where().col("w", "sortOrder").eq().raw("(").select().raw("MAX(").col("w", "sortOrder").raw(")").from("w").where().col("w", "aoparent").eq().numeric(epicId).raw(")");
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return epicId;
            }
        });
    }
}

