/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ILegacyProjectEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;

public class FixedActivityFilter
implements Predicate<IActivitySchedule> {
    private final IResourceGroup resourceGroup;
    private final Map<IActivity, Set<IResourceGroup>> possibleActivityAssignments;
    private final int startTime;
    private final int endTime;

    FixedActivityFilter(IResourceGroup resourceGroup, Map<IActivity, Set<IResourceGroup>> possibleActivityAssignments, int startTime, int endTime) {
        this.resourceGroup = resourceGroup;
        this.possibleActivityAssignments = possibleActivityAssignments;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public boolean apply(IActivitySchedule input) {
        IActivity activity = input.getActivity();
        if (!this.possibleActivityAssignments.keySet().contains(activity)) {
            return false;
        }
        if (input.getReleaseTime() > this.startTime) {
            return false;
        }
        if (input.getEnd() <= this.endTime) {
            return false;
        }
        Set<IResourceGroup> possibleAssignments = this.possibleActivityAssignments.get(activity);
        return possibleAssignments != null && possibleAssignments.contains(this.resourceGroup);
    }

    public static FixedActivityFilter createInstance(IWorkSlot workSlot, IResourceGroup resourceGroup, ILegacyProjectEpisode episode) {
        FixedActivityFilter instance = new FixedActivityFilter(resourceGroup, RmSchedulingUtils.getPossibleActivityAssignments(episode.getAssignedWorkPackages()), workSlot.getStart(), workSlot.getEnd());
        return instance;
    }
}

