/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.api.plugins.service;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import com.atlassian.rm.common.bridges.api.plugins.service.JiraServiceOutcomeHandlerAction;

public class BaseBundleServiceJiraServiceOutcomeHandler {
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;
    private final String serviceName;

    public BaseBundleServiceJiraServiceOutcomeHandler(BundleServiceAccessorProvider bundleServiceAccessorProvider, String serviceName) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
        this.serviceName = serviceName;
    }

    public <TService, TServiceOutcomeValue, TRetVal> TRetVal forServiceAccessor(final JiraServiceOutcomeHandlerAction<TService, TServiceOutcomeValue, TRetVal> action) throws Exception {
        BundleServiceAccessor bundleServiceAccessor = this.bundleServiceAccessorProvider.createServiceAccessor(this.serviceName);
        return (TRetVal)bundleServiceAccessor.perform(new ServiceCallback<TService, TRetVal>(){

            @Override
            public TRetVal perform(TService service) throws Exception {
                ServiceOutcome serviceOutcome = action.getServiceOutcome(service);
                if (BaseBundleServiceJiraServiceOutcomeHandler.this.hasErrors(serviceOutcome)) {
                    return action.handleErrors(serviceOutcome);
                }
                Object serviceOutcomeValue = serviceOutcome.getReturnedValue();
                return action.getResult(serviceOutcomeValue);
            }
        });
    }

    private boolean hasErrors(ServiceOutcome serviceOutcomeCasted) {
        return serviceOutcomeCasted.getErrorCollection() != null && serviceOutcomeCasted.getErrorCollection().getErrorMessages() != null && serviceOutcomeCasted.getErrorCollection().getErrorMessages().size() > 0;
    }
}

