/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.views.licenses;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.event.mau.MauEventServiceBridgeProxy;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.radiantminds.plugins.jira.views.BaseAutheticatedRoadmapsView;
import com.radiantminds.plugins.jira.views.VelocityAccess;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioCustomWordingPersistence;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.licenses.JiraLicenseExtension;
import org.joda.time.DateTime;

@WebSudoRequired
public class DetailsAction
extends BaseAutheticatedRoadmapsView {
    private static final Log LOGGER = Log.with(DetailsAction.class);
    private final FeatureExtension featureExtension;

    public DetailsAction(PluginLicenseManager licenseManager, FeatureManager featureManager, FeatureExtension featureExtension, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PluginPermissions pluginPermissionHandler, PortfolioCustomWordingPersistence customWordingPersistence, MetaDataUtils metaDataUtils, JiraAgileAccessor agileAccessor, MauEventServiceBridgeProxy mauEventServiceBridgeProxy, JiraLicenseExtension jiraLicenseExtension) {
        super(PluginPermission.or(PluginPermission.Admin), authenticationContext, licenseManager, featureManager, featureExtension, applicationProperties, pluginPermissionHandler, customWordingPersistence, agileAccessor, metaDataUtils, mauEventServiceBridgeProxy, jiraLicenseExtension);
        this.featureExtension = featureExtension;
    }

    @Override
    protected boolean skipLicenceCheck() {
        return true;
    }

    @Override
    public String execute() throws Exception {
        String actionResult = super.execute();
        return actionResult;
    }

    @VelocityAccess
    public boolean getIsLicensed() {
        return this.getLicenseData().isValid();
    }

    @VelocityAccess
    public boolean getIsLicensedFromProduct() {
        return this.getProductLicense().isValid();
    }

    @VelocityAccess
    public String getPluginVersion() {
        return this.metaDataUtils.getVersion().toString();
    }

    @VelocityAccess
    public String getLicensedTo() {
        return DetailsAction.getValueOrUnknown(((PluginLicense)this.licenseManager.getLicense().get()).getOrganization().getName());
    }

    @VelocityAccess
    public String getPurchaseDate() {
        if (((PluginLicense)this.licenseManager.getLicense().get()).getPurchaseDate() != null) {
            try {
                return DetailsAction.getValueOrUnknown(DetailsAction.formatDate(this.getDmyDateFormatter(), (DateTime)((PluginLicense)this.licenseManager.getLicense().get()).getMaintenanceExpiryDate().get()));
            }
            catch (Exception ex) {
                LOGGER.warn("Could not retrieve purchase date.", new Object[0]);
                LOGGER.exception(ex, Log.LogLevel.WARN);
            }
        }
        return "Unknown";
    }

    @VelocityAccess
    public boolean isAgileAvailable() {
        return this.agileAccessor.isAvailable();
    }

    @Override
    @VelocityAccess
    public boolean isRebrandEnabled() {
        return this.featureExtension.isRebrandEnabled();
    }

    @VelocityAccess
    public boolean isAgileAvailableAndLicensed() {
        return this.agileAccessor.isAvailableAndLicensed();
    }

    @Override
    @VelocityAccess
    public String getJiraVersion() {
        try {
            String jiraVersion = this.applicationProperties.getString("jira.version");
            String edition = this.applicationProperties.getString("jira.edition");
            if (edition != null) {
                return String.format("%s (%s)", jiraVersion, edition.toUpperCase());
            }
            return jiraVersion;
        }
        catch (Exception ex) {
            LOGGER.warn("Could not retrieve Jira version.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.WARN);
            return "Unknown";
        }
    }

    @VelocityAccess
    public String getLicenseType() {
        return DetailsAction.getValueOrUnknown(((PluginLicense)this.licenseManager.getLicense().get()).getLicenseType().name());
    }

    @VelocityAccess
    public String getMaintenanceExpiryDate() {
        try {
            if (((PluginLicense)this.licenseManager.getLicense().get()).getMaintenanceExpiryDate().isDefined()) {
                return DetailsAction.getValueOrUnknown(DetailsAction.formatDate(this.getDmyDateFormatter(), (DateTime)((PluginLicense)this.licenseManager.getLicense().get()).getMaintenanceExpiryDate().get()));
            }
            return "Unknown";
        }
        catch (Exception ex) {
            LOGGER.warn("Could not retrieve maintenance expiry date.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.WARN);
            return "Unknown";
        }
    }

    private static String getValueOrUnknown(String value) {
        return value != null ? value : "Unknown";
    }

    private static String formatDate(DateTimeFormatter formatter, DateTime date) {
        if (formatter != null && date != null) {
            return formatter.format(date.toDate());
        }
        return null;
    }
}

