/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IBacklog;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Backlog
implements IBacklog {
    private final IDependencyDefinition dependencyDefinition;
    private final Set<IScheduleViolation> violations;
    private final Set<IScheduleWarning> warnings;

    private Backlog(IDependencyDefinition dependencyDefinition, Set<IScheduleViolation> violations, Set<IScheduleWarning> scheduleWarnings) {
        this.dependencyDefinition = dependencyDefinition;
        this.violations = Collections.unmodifiableSet(violations);
        this.warnings = scheduleWarnings;
    }

    @Override
    public IDependencyDefinition getDependencyDefinition() {
        return this.dependencyDefinition;
    }

    @Override
    public Set<IScheduleViolation> getViolations() {
        return this.violations;
    }

    @Override
    public Set<IProcessingItem> getProcessingItems() {
        return this.dependencyDefinition.getProcessingItems();
    }

    @Override
    public Set<IUnstructuredItem> getUnstructuredItems() {
        HashSet unstructured = Sets.newHashSet();
        for (IProcessingItem processingItem : this.getProcessingItems()) {
            if (!processingItem.getProcessingItemType().equals((Object)ProcessingItemType.Unstructured)) continue;
            unstructured.add((IUnstructuredItem)processingItem);
        }
        return unstructured;
    }

    @Override
    public Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public Set<IProcessingItem> getItemsWithStrictEpisodeAssignment() {
        HashSet strictlyAssignedItemIds = Sets.newHashSet();
        for (IProcessingItem item : this.getProcessingItems()) {
            if (!item.isStrictlyAssigned()) continue;
            strictlyAssignedItemIds.add(item);
        }
        return strictlyAssignedItemIds;
    }

    public static Backlog createInstance(IDependencyDefinition dependencyDefinition, Set<IScheduleViolation> violations, Set<IScheduleWarning> scheduleWarnings) {
        return new Backlog(dependencyDefinition, violations, scheduleWarnings);
    }
}

