/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.api.plugins.access;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;

class DefaultUnsafeBundleServiceAccessor<T>
implements BundleServiceAccessor<T> {
    private static final String OBJECT_CLASS_PROPERTY = "objectClass";
    private static final String APPLICATION_CONTEXT_CLASS = "org.springframework.context.ApplicationContext";
    private static final Log LOGGER = Log.with(DefaultUnsafeBundleServiceAccessor.class);
    private final BundleContext bundleContext;
    private final String pluginKey;
    private final String beanName;

    public DefaultUnsafeBundleServiceAccessor(BundleContext bundleContext, String pluginKey, String beanName) {
        this.bundleContext = bundleContext;
        this.pluginKey = pluginKey;
        this.beanName = beanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> U perform(ServiceCallback<T, U> callback) throws Exception {
        Bundle bundle = this.findBundleForPlugin();
        Object[] registeredServices = bundle.getRegisteredServices();
        ServiceReference serviceReference = (ServiceReference)Iterables.find((Iterable)Lists.newArrayList((Object[])registeredServices), (Predicate)new Predicate<ServiceReference>(){

            public boolean apply(ServiceReference serviceReference) {
                Object objectClass = serviceReference.getProperty(DefaultUnsafeBundleServiceAccessor.OBJECT_CLASS_PROPERTY);
                if (objectClass instanceof String[]) {
                    Object[] objectClasses = (String[])objectClass;
                    return Iterables.contains((Iterable)Lists.newArrayList((Object[])objectClasses), (Object)DefaultUnsafeBundleServiceAccessor.APPLICATION_CONTEXT_CLASS);
                }
                return false;
            }
        });
        U retVal = null;
        try {
            ApplicationContext applicationContext = (ApplicationContext)this.bundleContext.getService(serviceReference);
            Object service = applicationContext.getBean(this.beanName);
            retVal = callback.perform(service);
        }
        finally {
            this.bundleContext.ungetService(serviceReference);
        }
        return retVal;
    }

    private Bundle findBundleForPlugin() {
        ArrayList bundles = Lists.newArrayList((Object[])this.bundleContext.getBundles());
        return this.findBundleForPlugin(bundles);
    }

    private Bundle findBundleForPlugin(Iterable<Bundle> bundles) {
        return (Bundle)Iterables.find(bundles, (Predicate)new Predicate<Bundle>(){

            public boolean apply(Bundle b) {
                return DefaultUnsafeBundleServiceAccessor.this.pluginKey.equals(b.getHeaders().get("Atlassian-Plugin-Key"));
            }
        }, null);
    }
}

