/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceCostCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.MutableResourceCostCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ResourceToTypeWeightVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IPartialUnstructuredItemStageProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.IUnstructuredStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.IUnstructuredStageLpProblemCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.UnstructuredStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnstructuredStageLpProblemCreator
implements IUnstructuredStageLpProblemCreator {
    private static final Log LOGGER = Log.with(UnstructuredStageLpProblemCreator.class);
    private final IMutableResourceCostCalculator resourceCostsCalculator;

    public UnstructuredStageLpProblemCreator() {
        this(new MutableResourceCostCalculator());
    }

    UnstructuredStageLpProblemCreator(IMutableResourceCostCalculator resourceCostsCalculator) {
        this.resourceCostsCalculator = resourceCostsCalculator;
    }

    @Override
    public Optional<IUnstructuredStageLpProblem> tryCreateInstance(IPartialUnstructuredItemStageProblem problem, PositivePrimitivesMap<IMutableResource> availableWork) {
        LogUtil.debug(LOGGER, "try to create for problem: %s", problem);
        if (availableWork.isEmpty()) {
            LogUtil.debug(LOGGER, "no work force available");
            return Optional.absent();
        }
        Set<IResourceType> neededTypes = problem.getResourceTypes();
        Map<IMutableResource, Set<IResourceType>> resourceToSkillMap = RmSchedulingUtils.getNeededSkillsMap(availableWork.keySet(), neededTypes);
        ArrayList variables = Lists.newArrayList();
        HashMap resIndices = Maps.newHashMap();
        HashMap typeIndices = Maps.newHashMap();
        for (IMutableResource resource : RmSortableUtils.sort(resourceToSkillMap.keySet())) {
            Set<IResourceType> availableNeededTypes = resourceToSkillMap.get(resource);
            for (IResourceType type : RmSortableUtils.sort(availableNeededTypes)) {
                int index = variables.size();
                ResourceToTypeWeightVariable variable = new ResourceToTypeWeightVariable(resource, type, problem.getProcessingStage());
                variables.add(variable);
                RmUtils.addToKeyedSets(resIndices, resource, index);
                RmUtils.addToKeyedSets(typeIndices, type, index);
            }
        }
        if (variables.isEmpty()) {
            LogUtil.debug(LOGGER, "no problem can be generated");
            return Optional.absent();
        }
        IRoadmapProblemStatistics projectStatistics = problem.getProjectStatistics();
        Set<IMutableResource> resources = resIndices.keySet();
        PrimitivesMap<IMutableResource> cost = this.resourceCostsCalculator.getResourceCosts(projectStatistics, resources);
        PositivePrimitivesMap<IResourceType> filteredTypeLimits = RmCollectionUtils.filterKeys(problem.getPositiveTypeAmounts(), Predicates.in(typeIndices.keySet()));
        PositivePrimitivesMap<IMutableResource> filteredAvailableWork = RmCollectionUtils.filterKeys(availableWork, Predicates.in(resIndices.keySet()));
        UnstructuredStageLpProblem instance = new UnstructuredStageLpProblem(problem.getId(), variables, resIndices, typeIndices, problem.getMinimumWorkLoad(), problem.getEligibleWorkAmount(), filteredTypeLimits, filteredAvailableWork, cost, problem.getProjectEpisode());
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return Optional.of((Object)instance);
    }
}

