/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IntervalPadding {
    public List<IIntegerInterval> createPaddingIntervals(List<? extends IIntegerInterval> fixedIntervals, int defaultPaddingLength) {
        return this.createPaddingIntervals(fixedIntervals, defaultPaddingLength, 0);
    }

    public List<IIntegerInterval> createPaddingIntervals(List<? extends IIntegerInterval> fixedIntervals, int defaultPaddingLength, int offset) {
        if (fixedIntervals.isEmpty()) {
            return this.createOffsetOnlyPadding(offset, defaultPaddingLength);
        }
        ListIterator<? extends IIntegerInterval> iterator = fixedIntervals.listIterator();
        IIntegerInterval lastInterval = iterator.next();
        ArrayList paddedIntervals = Lists.newArrayList();
        while (iterator.hasNext()) {
            IIntegerInterval nextInterval = iterator.next();
            if (this.isPaddingNeeded(nextInterval.getStart() - lastInterval.getEnd(), defaultPaddingLength)) {
                List<IIntegerInterval> paddingIntervals = this.createPaddingIntervals(lastInterval.getEnd() + 1, nextInterval.getStart() - 1, defaultPaddingLength);
                paddedIntervals.addAll(paddingIntervals);
            }
            lastInterval = nextInterval;
        }
        if (this.isPaddingNeeded(fixedIntervals.get(0).getStart() - offset, defaultPaddingLength)) {
            List<IIntegerInterval> frontPadding = this.createPaddingIntervals(offset, fixedIntervals.get(0).getStart() - 1, defaultPaddingLength);
            frontPadding.addAll(paddedIntervals);
            return frontPadding;
        }
        return paddedIntervals;
    }

    private boolean isPaddingNeeded(int gap, int defaultPaddingLength) {
        return (double)gap >= (double)defaultPaddingLength / 2.0;
    }

    private List<IIntegerInterval> createOffsetOnlyPadding(int offset, int defaultPaddingLength) {
        if (offset == 0) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new IIntegerInterval[]{new IntegerInterval(offset, offset + defaultPaddingLength - 1)});
    }

    private List<IIntegerInterval> createPaddingIntervals(int start, int limit, int defaultPaddingLength) {
        int nextEnd;
        ArrayList paddingIntervals = Lists.newArrayList();
        if (!this.isPaddingNeeded(limit - start + 1, defaultPaddingLength)) {
            return paddingIntervals;
        }
        while ((nextEnd = this.getNextEnd(start, limit, defaultPaddingLength)) > start) {
            paddingIntervals.add(new IntegerInterval(start, nextEnd));
            start = nextEnd + 1;
        }
        return paddingIntervals;
    }

    private int getNextEnd(int start, int limit, int defaultPaddingLength) {
        int defaultEnd = start + defaultPaddingLength - 1;
        if (!this.isPaddingNeeded(limit - defaultEnd, defaultPaddingLength)) {
            return limit;
        }
        return defaultEnd;
    }
}

