/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.sorting;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.MoveMode;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.SortingSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.TransactionalSortingSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemSelectSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ICustomTransaction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class WorkItemSortOrderUpdateSQL
extends BaseTransactionalAOPersistenceSQL {
    private final WorkItemSelectSQL workItemSelectSQL;
    private final SortingSQL sortingSQL;
    private final TransactionalSortingSQL transactionalSortingSQL;

    public WorkItemSortOrderUpdateSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.workItemSelectSQL = new WorkItemSelectSQL(activeObjectsUtilities);
        this.sortingSQL = new SortingSQL(activeObjectsUtilities);
        this.transactionalSortingSQL = new TransactionalSortingSQL(activeObjectsUtilities);
    }

    public void move(final String itemToMove, final String target, MoveMode requestedMode) throws SQLException {
        final MoveMode mode = target == null ? MoveMode.TOP : requestedMode;
        this.inCustomTransaction(new ICustomTransaction<Void>(){

            @Override
            public Void execute(Connection connection) throws SQLException {
                boolean isStoryOrUnstructuredEpic = WorkItemSortOrderUpdateSQL.this.sortingSQL.getSortOrderInCustomTransaction(AOWorkItem.class, itemToMove, connection) != null;
                String rangeIdentifier = WorkItemSortOrderUpdateSQL.this.getRangeIdentifierConsideringChildren(itemToMove, connection);
                String actualMoveTarget = null;
                if (target != null) {
                    actualMoveTarget = WorkItemSortOrderUpdateSQL.this.getValidMoveTarget(itemToMove, target, rangeIdentifier, mode, connection);
                }
                if (actualMoveTarget != null && actualMoveTarget.equals(itemToMove)) {
                    return null;
                }
                if (isStoryOrUnstructuredEpic) {
                    WorkItemSortOrderUpdateSQL.this.transactionalSortingSQL.getMoveTransaction(AOWorkItem.class, rangeIdentifier, itemToMove, mode, actualMoveTarget).execute(connection);
                } else {
                    List<String> childIds = WorkItemSortOrderUpdateSQL.this.workItemSelectSQL.getChildrenInCustomTransaction(itemToMove, connection);
                    Collections.reverse(childIds);
                    for (String childId : childIds) {
                        WorkItemSortOrderUpdateSQL.this.transactionalSortingSQL.getMoveTransaction(AOWorkItem.class, rangeIdentifier, childId, mode, actualMoveTarget).execute(connection);
                    }
                }
                return null;
            }
        });
    }

    private String getValidMoveTarget(String itemToMove, String target, String rangeIdentifier, MoveMode mode, Connection connection) throws SQLException {
        Long sortOrder = this.sortingSQL.getSortOrderInCustomTransaction(AOWorkItem.class, target, connection);
        if (sortOrder != null) {
            return target;
        }
        Pair<String, Long> sortOrderPair = this.getSortOrderConsiderChildren(target, itemToMove, rangeIdentifier, connection);
        sortOrder = sortOrderPair.getRight();
        boolean isChild = this.workItemSelectSQL.isDirectChildOf(itemToMove, target, connection);
        if (isChild) {
            if (sortOrder == null) {
                return itemToMove;
            }
            return this.getItemBySortOrder(rangeIdentifier, sortOrder - 1L, connection);
        }
        if (mode == MoveMode.BEFORE) {
            return sortOrderPair.getLeft();
        }
        String sortOrderItemBeforeNextValidSortOrder = this.getSortOrderItemBeforeNextValidSortOrder(target, rangeIdentifier, sortOrder, connection);
        if (sortOrderItemBeforeNextValidSortOrder == null) {
            return this.getItemWithHighestSortOrder(rangeIdentifier, connection);
        }
        return sortOrderItemBeforeNextValidSortOrder;
    }

    private String getRangeIdentifierConsideringChildren(final String id, Connection connection) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                ArrayList hierarchies = Lists.newArrayList();
                for (int i = 0; i < 3; ++i) {
                    hierarchies.add("w" + i);
                    generator.withTable(AOWorkItem.class, (String)hierarchies.get(i));
                }
                generator.select().raw("COALESCE(");
                for (String hierarchy : hierarchies) {
                    generator.col(hierarchy, "orderRangeIdentifier");
                }
                generator.raw(")").from((String)hierarchies.get(0));
                for (int i = 1; i < hierarchies.size(); ++i) {
                    generator.leftJoin().table((String)hierarchies.get(i)).on().colId((String)hierarchies.get(i - 1)).eq().col((String)hierarchies.get(i), "aoParent");
                }
                generator.where().colId((String)hierarchies.get(0)).eq().numeric(id);
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        }, connection, false);
    }

    private String getItemBySortOrder(final String orderRangeIdentifier, final Long sortOrder, Connection connection) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "t").select().colId("t").from("t").where().col("t", "orderRangeIdentifier").eq().str(orderRangeIdentifier).and().col("t", "sortOrder").eq().numeric(sortOrder);
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        }, connection, false);
    }

    private String getSortOrderItemBeforeNextValidSortOrder(final String itemId, final String rangeIdentifier, final Long itemSortOrder, Connection connection) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").withTable(AOWorkItem.class, "i").select().colId("w").from("w").where().col("w", "sortOrder").lt().raw("(").select().raw("MIN(").col("i", "sortOrder").raw(")").from("i").where().raw("(").col("i", "aoParent").isNull().or().col("i", "aoParent").neq().numeric(itemId).raw(")").and().col("i", "sortOrder").gt().numeric(itemSortOrder).and().col("i", "orderRangeIdentifier").eq().str(rangeIdentifier).raw(")").and().col("w", "orderRangeIdentifier").eq().str(rangeIdentifier).orderBy().col("w", "sortOrder").desc();
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        }, connection, false);
    }

    private String getItemWithHighestSortOrder(final String rangeIdentifier, Connection connection) throws SQLException {
        return this.sql(new IQuery<String>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").withTable(AOWorkItem.class, "i").select().colId("w").from("w").where().col("w", "orderRangeIdentifier").eq().str(rangeIdentifier).and().col("w", "sortOrder").eq().raw("(").select().raw("MAX(").col("i", "sortOrder").raw(")").from("i").where().col("i", "orderRangeIdentifier").eq().str(rangeIdentifier).raw(")");
            }

            @Override
            public String handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getString(result, 1);
                }
                return null;
            }
        }, connection, false);
    }

    private Pair<String, Long> getSortOrderConsiderChildren(final String id, final String childIdToIgnore, final String rangeIdentifier, Connection connection) throws SQLException {
        return this.sql(new IQuery<Pair<String, Long>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                int i;
                generator.withTable(AOWorkItem.class, "w").select().colId("w").col("w", "sortOrder").from("w").where().col("w", "orderRangeIdentifier").eq().str(rangeIdentifier).and().col("w", "sortOrder").eq().raw("(");
                ArrayList hierarchies = Lists.newArrayList();
                for (int i2 = 0; i2 < 3; ++i2) {
                    hierarchies.add("w" + i2);
                    generator.withTable(AOWorkItem.class, (String)hierarchies.get(i2));
                }
                generator.select().raw("MIN(COALESCE(");
                for (String hierarchy : hierarchies) {
                    generator.col(hierarchy, "sortOrder");
                }
                generator.raw("))").from((String)hierarchies.get(0));
                for (i = 1; i < hierarchies.size(); ++i) {
                    generator.leftJoin().table((String)hierarchies.get(i)).on().colId((String)hierarchies.get(i - 1)).eq().col((String)hierarchies.get(i), "aoParent");
                }
                generator.where().colId((String)hierarchies.get(0)).eq().numeric(id);
                for (i = 1; i < hierarchies.size(); ++i) {
                    generator.and().raw("(").colId((String)hierarchies.get(i)).isNull().or().colId((String)hierarchies.get(i)).neq().numeric(childIdToIgnore).raw(")");
                }
                generator.raw(")");
            }

            @Override
            public Pair<String, Long> handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    String id2 = BaseAOPersistenceSQL.getString(result, 1);
                    Long sortOrder = WorkItemSortOrderUpdateSQL.getLong(result, 2);
                    return Pair.of(id2, sortOrder);
                }
                return Pair.of(null, null);
            }
        }, connection, false);
    }
}

