/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync;

import com.atlassian.jira.issue.IssueInputParameters;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.FormattingUtils;

public class EstimateSyncUtils {
    public static boolean setEstimatesOnJiraIssue(IssueInputParameters issueInputParameters, Optional<Double> current, Optional<Double> original, String planningUnit, Double hoursPerDay, boolean timetrackingIsLegacyMode) {
        if (!timetrackingIsLegacyMode) {
            if (current.isPresent() && original.isPresent()) {
                issueInputParameters.setOriginalAndRemainingEstimate(FormattingUtils.toJiraMinuteString((Double)original.get(), planningUnit, hoursPerDay), FormattingUtils.toJiraMinuteString((Double)current.get(), planningUnit, hoursPerDay));
            } else if (current.isPresent()) {
                issueInputParameters.setRemainingEstimate(FormattingUtils.toJiraMinuteString((Double)current.get(), planningUnit, hoursPerDay));
            } else if (original.isPresent()) {
                issueInputParameters.setOriginalEstimate(FormattingUtils.toJiraMinuteString((Double)original.get(), planningUnit, hoursPerDay));
            }
            return true;
        }
        if (current.isPresent()) {
            issueInputParameters.setRemainingEstimate(FormattingUtils.toJiraMinuteString((Double)current.get(), planningUnit, hoursPerDay));
            return true;
        }
        return false;
    }
}

