/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync.releases;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.handlers.sync.releases.ReleaseSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.releases.ValidReleaseSyncRequest;
import java.util.List;

public class ValidatedReleaseSyncRequestImpl
implements ValidReleaseSyncRequest {
    private final List<String> releaseIds;
    private final boolean syncStartDate;
    private final boolean syncReleaseDate;
    private final boolean syncName;

    private ValidatedReleaseSyncRequestImpl(List<String> releaseIds, boolean syncStartDate, boolean syncReleaseDate, boolean syncName) {
        this.releaseIds = releaseIds;
        this.syncStartDate = syncStartDate;
        this.syncReleaseDate = syncReleaseDate;
        this.syncName = syncName;
    }

    @Override
    public List<String> getReleaseIds() {
        return this.releaseIds;
    }

    @Override
    public boolean isSyncStartDate() {
        return this.syncStartDate;
    }

    @Override
    public boolean isSyncReleaseDate() {
        return this.syncReleaseDate;
    }

    @Override
    public boolean isSyncName() {
        return this.syncName;
    }

    public static Optional<ValidReleaseSyncRequest> validate(ReleaseSyncConfiguration config) {
        if (config == null) {
            return Optional.absent();
        }
        List releaseIds = (List)config.getReleaseIds().orNull();
        if (releaseIds == null || releaseIds.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new ValidatedReleaseSyncRequestImpl((List)config.getReleaseIds().get(), (Boolean)config.getSyncStartDate().or((Object)false), (Boolean)config.getSyncReleaseDate().or((Object)false), (Boolean)config.getSyncName().or((Object)false)));
    }
}

