/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestIdList;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.filter.RestWorkItemFilter;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.rest.services.workitems.PlanWorkItemServiceHandler;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/plans/{id}/workitems")
@Component
public class PlanWorkItemService {
    private final PlanWorkItemServiceHandler handler;

    @Autowired
    public PlanWorkItemService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioStagePersistence stagePersistence, PortfolioTeamPersistence teamPersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, PortfolioReleasePersistence releasePersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension, Scheduling scheduling) {
        this.handler = handlerFactory.createProxy(PlanWorkItemServiceHandler.class, new PlanWorkItemServiceHandler.Impl(activeObjectsUtilities, planPersistence, workItemPersistence, estimatePersistence, extensionLinkPersistence, releasePersistence, teamPersistence, stagePersistence, portfolioToJiraSyncExtension, scheduling), planPersistence);
    }

    @POST
    @Path(value="/get")
    public Response getSpecificWorkItemsWithPost(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, @QueryParam(value="replanning") Boolean replanning, RestIdList workItemIds) throws Exception {
        return this.handler.getSpecificWorkItemsWithPost(EntityContext.from(planId, expectedPlanVersion, clientId), (Boolean)Optional.fromNullable((Object)replanning).or((Object)false), workItemIds);
    }

    @POST
    @Path(value="/filter")
    public Response getFiltered(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, @QueryParam(value="replanning") Boolean replanning, @QueryParam(value="nativeOrder") Boolean useNativeOrder, RestWorkItemFilter filter) throws Exception {
        return this.handler.getFiltered(EntityContext.from(planId, expectedPlanVersion, clientId), (Boolean)Optional.fromNullable((Object)replanning).or((Object)false), (Boolean)Optional.fromNullable((Object)useNativeOrder).or((Object)false), filter);
    }

    @GET
    public Response getAll(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="replanning") Boolean replanning, @QueryParam(value="nativeOrder") Boolean useNativeOrder) throws Exception {
        return this.handler.getAll(EntityContext.from(planId, expectedPlanVersion), (Boolean)Optional.fromNullable((Object)replanning).or((Object)false), (Boolean)Optional.fromNullable((Object)useNativeOrder).or((Object)false));
    }

    @POST
    public Response addToPlan(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestWorkItem newWorkItem) throws Exception {
        return this.handler.addToPlan(EntityContext.from(planId, expectedPlanVersion, clientId), newWorkItem);
    }

    @PUT
    @Path(value="/rank")
    public Response rank(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rank(EntityContext.from(planId, expectedPlanVersion, clientId), rank);
    }
}

