/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

abstract class AOStringifiedInQueryGenerator
extends AOQueryGenerator {
    protected AOStringifiedInQueryGenerator(Connection connection, ActiveObjectsUtilities activeObjectsUtilities) throws SQLException {
        super(connection, activeObjectsUtilities);
    }

    @Override
    public AOQueryGenerator inNumeric(AOQueryGenerator.InOperandCallback operandCallback, Collection<String> values) throws SQLException {
        return this.inStringified(operandCallback, values);
    }

    private AOQueryGenerator inStringified(AOQueryGenerator.InOperandCallback operandCallback, Collection<String> values) throws SQLException {
        String operand = this.getOperand(operandCallback);
        new NumericInClausStringGenerator(this.query).append(values, operand);
        this.lastCol = false;
        return this;
    }

    public static class NumericInClausStringGenerator {
        private final StringBuilder stringBuilder;

        public NumericInClausStringGenerator(StringBuilder stringBuilder) {
            this.stringBuilder = stringBuilder;
        }

        public void append(Collection<String> numericStringValues, String operand) throws NumberFormatException {
            this.stringBuilder.append(operand);
            this.stringBuilder.append(" IN (");
            boolean comma = false;
            for (String value : numericStringValues) {
                if (comma) {
                    this.stringBuilder.append(", ");
                } else {
                    comma = true;
                }
                int intVal = Integer.parseInt(value);
                String param = Integer.toString(intVal);
                this.stringBuilder.append(param);
            }
            this.stringBuilder.append(")");
        }
    }
}

