/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.system.issuelinks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.IssueLinkRequest;
import com.radiantminds.roadmap.common.rest.entities.workitems.dependencies.RestWorkItemDependencies;
import com.radiantminds.roadmap.common.utils.dependencies.DependencyUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class DefaultCreateIssueLinksForDependenciesRequest
implements IssueLinkRequest {
    List<String> inwardIds;
    List<String> outwardIds;
    String linkTypeId;
    Set<String> issueKeys;

    private DefaultCreateIssueLinksForDependenciesRequest(String linkTypeId) {
        this.linkTypeId = linkTypeId;
        this.inwardIds = Lists.newArrayList();
        this.outwardIds = Lists.newArrayList();
        this.issueKeys = Sets.newHashSet();
    }

    public static IssueLinkRequest create(String workItemId, String issueKey, String linkTypeId, List<String> ignoredWorkItemIds, PortfolioExtensionLinkPersistence extensionLinkEntityPersistence, PortfolioWorkItemPersistence workItemPersistence) throws SQLException {
        DefaultCreateIssueLinksForDependenciesRequest issueLinkRequest = new DefaultCreateIssueLinksForDependenciesRequest(linkTypeId);
        issueLinkRequest.addIssueKey(issueKey);
        RestWorkItemDependencies dependencies = workItemPersistence.getDependencies(workItemId, true);
        List<String> requiresIds = DependencyUtils.getRealDependencies(dependencies.getRequires(), ignoredWorkItemIds);
        List<String> requiredByIds = DependencyUtils.getRealDependencies(dependencies.getRequiredBy(), ignoredWorkItemIds);
        issueLinkRequest.addInwardIds(DependencyUtils.getLinkedIssueKeysForWorkItemIds(extensionLinkEntityPersistence, requiresIds));
        issueLinkRequest.addOutwardIds(DependencyUtils.getLinkedIssueKeysForWorkItemIds(extensionLinkEntityPersistence, requiredByIds));
        return issueLinkRequest;
    }

    @Override
    public List<String> getInwardIds() {
        return this.inwardIds;
    }

    @Override
    public List<String> getOutwardIds() {
        return this.outwardIds;
    }

    @Override
    public Set<String> getIssueKeys() {
        return this.issueKeys;
    }

    @Override
    public String getLinkTypeId() {
        return this.linkTypeId;
    }

    private void addInwardIds(List<String> ids) {
        this.inwardIds.addAll(ids);
    }

    private void addOutwardIds(List<String> ids) {
        this.outwardIds.addAll(ids);
    }

    private void addIssueKey(String issueKey) {
        this.issueKeys.add(issueKey);
    }
}

