/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.ExtensionLink;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.AOExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtensionLinkSQL
extends BaseAOPersistenceSQL {
    private final EntityInfoSQL entityInfoSQL;

    public ExtensionLinkSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.entityInfoSQL = new EntityInfoSQL(activeObjectsUtilities);
    }

    public Map<String, List<IExtensionLink>> getExtensionLinksForPlan(final String planId, final Class<?> extendableClazz) throws SQLException {
        return this.sql(new IQuery<Map<String, List<IExtensionLink>>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "d").withTable(extendableClazz, "w").select().col("d", "aoExtendable").col("d", "extensionKey").col("d", "extensionLink").from("d").where().colPolyType("d", "aoExtendable").eq().str(extendableClazz.getName()).and().colAsInt("d", "aoExtendable").raw("IN (").select().colId("w").from("w").where().col("w", "aoplan").eq().numeric(planId).raw(")");
            }

            @Override
            public Map<String, List<IExtensionLink>> handleResult(ResultSet result) throws Exception {
                return ExtensionLinkSQL.buildExtensionLinkObjects(result);
            }
        });
    }

    public void delete(final Class<?> extendableClazz, final String extendableId, final String key, final String value) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "x").deleteFrom().tableNoAlias("x").where().colPolyTypeNoAlias("x", "aoExtendable").eq().str(extendableClazz.getName()).and().colNoAlias("x", "aoExtendable").eq().numeric(extendableId).and().colNoAlias("x", "extensionKey").eq().str(key).and().colNoAlias("x", "extensionLink").eq().str(value);
            }
        });
    }

    public void add(final Class<?> extendableClazz, final String extendableId, final String key, final String value) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "l").insert().tableNoAlias("l").raw("(").colNoAlias("l", "aoExtendable").colPolyTypeNoAlias("l", "aoExtendable").colNoAlias("l", "extensionKey").colNoAlias("l", "extensionLink").colNoAlias("l", "version").raw(") VALUES (").raw(extendableId).raw(",").str(extendableClazz.getName()).raw(",").str(key).raw(",").str(value).raw(",").numeric(1).raw(")");
            }
        });
    }

    public EntityInfo getEntityInfo(final String linkId) throws SQLException {
        return this.sql(new IQuery<EntityInfo>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "l").select().col("l", "aoextendable").colPolyType("l", "aoextendable").from("l").where().colId("l").eq().numeric(linkId);
            }

            @Override
            public EntityInfo handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    String fk = BaseAOPersistenceSQL.getString(result, 1);
                    String type = BaseAOPersistenceSQL.getString(result, 2);
                    Class<?> extendable = Class.forName(type);
                    return ExtensionLinkSQL.this.entityInfoSQL.getEntityInfo(fk, extendable, new EntityInfoSQL.ParentRelationship[0]);
                }
                return null;
            }
        });
    }

    public List<String> getTargetIdsForLink(final Class<?> extendableClazz, final String key, final String link) throws SQLException {
        return this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "x").select().col("x", "aoextendable").from("x").where().colPolyType("x", "aoextendable").eq().str(extendableClazz.getName()).and().col("x", "extensionKey").startsWith(key).and().col("x", "extensionLink").eq().str(link);
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return retVal;
            }
        });
    }

    public void removeAllExtensionLinks(final String key, final String link) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "x").deleteFrom().tableNoAlias("x").where().colNoAlias("x", "extensionKey").like(key).and().colNoAlias("x", "extensionLink").eq().str(link);
            }
        });
    }

    public void removeAllExtensionLinksWithKey(final Class<?> targetClazz, final String key) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "x").deleteFrom().tableNoAlias("x").where().colPolyTypeNoAlias("x", "aoExtendable").eq().str(targetClazz.getName()).and().colNoAlias("x", "extensionKey").eq().str(key);
            }
        });
    }

    public void removeAllExtensionLinksWhereKeyLike(final Class<?> targetClazz, final String targetId, final String key, final String ... unlessKey) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "x").deleteFrom().tableNoAlias("x").where().colPolyTypeNoAlias("x", "aoExtendable").eq().str(targetClazz.getName()).and().colNoAlias("x", "aoExtendable").eq().numeric(targetId).and().colNoAlias("x", "extensionKey").like(key);
                for (String unless : unlessKey) {
                    generator.and().colNoAlias("x", "extensionKey").notLike(unless);
                }
            }
        });
    }

    public void removeAllExtensionLinksWhereValueStartsWith(final Class<?> targetClazz, final String targetId, final String key, final String projectPrefix) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "x").deleteFrom().tableNoAlias("x").where().colPolyTypeNoAlias("x", "aoExtendable").eq().str(targetClazz.getName()).and().colNoAlias("x", "aoExtendable").eq().numeric(targetId).and().colNoAlias("x", "extensionKey").eq().str(key).and().colNoAlias("x", "extensionLink").startsWith(projectPrefix);
            }
        });
    }

    public List<IExtensionLink> getLinksForTarget(final Class<?> extendableClazz, final String extendableId) throws SQLException {
        return this.sql(new IQuery<List<IExtensionLink>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "x").select().col("x", "aoExtendable").col("x", "extensionKey").col("x", "extensionLink").from("x").where().colPolyType("x", "aoExtendable").eq().str(extendableClazz.getName()).and().col("x", "aoExtendable").eq().numeric(extendableId);
            }

            @Override
            public List<IExtensionLink> handleResult(ResultSet result) throws Exception {
                Map links = ExtensionLinkSQL.buildExtensionLinkObjects(result);
                return (List)links.get(extendableId);
            }
        });
    }

    public Set<String> getExtensionLinksForPlan(final String planId) throws SQLException {
        return this.sql(new IQuery<Set<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOExtensionLink.class, "link").withTable(AOWorkItem.class, "item").select().col("link", "extensionLink").col("link", "aoExtendable").colId("item").col("item", "aoPlan").from("link").leftJoin().table("item").on().col("link", "aoExtendable").eq().colId("item").where().col("item", "aoplan").eq().numeric(planId);
            }

            @Override
            public Set<String> handleResult(ResultSet result) throws Exception {
                HashSet retVal = Sets.newHashSet();
                while (result.next()) {
                    String link = BaseAOPersistenceSQL.getString(result, 1);
                    retVal.add(link);
                }
                return retVal;
            }
        });
    }

    private static Map<String, List<IExtensionLink>> buildExtensionLinkObjects(ResultSet result) throws SQLException {
        HashMap retVal = Maps.newHashMap();
        while (result.next()) {
            String extendable = ExtensionLinkSQL.getString(result, 1);
            if (!retVal.containsKey(extendable)) {
                retVal.put(extendable, Lists.newArrayList());
            }
            ExtensionLink extensionLink = new ExtensionLink();
            extensionLink.setExtensionKey(ExtensionLinkSQL.getString(result, 2));
            extensionLink.setExtensionLink(ExtensionLinkSQL.getString(result, 3));
            ((List)retVal.get(extendable)).add(extensionLink);
        }
        return retVal;
    }
}

