/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.JiraLinkEnrichmentData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.RetrievedJiraIssue;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ExtensionLinkProgress;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FailSafeCustomFieldReader;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.SelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.HashMap;
import java.util.Map;

class FieldBasedSelfProgressExtractor
implements SelfProgressExtractor {
    private final FailSafeCustomFieldReader fieldReader;

    FieldBasedSelfProgressExtractor(FailSafeCustomFieldReader fieldReader) {
        this.fieldReader = fieldReader;
    }

    @Override
    public Map<String, ProgressData> getProgressData(Map<String, JiraLinkEnrichmentData> statusData) {
        HashMap progressMap = Maps.newHashMap();
        for (Map.Entry<String, JiraLinkEnrichmentData> entry : statusData.entrySet()) {
            JiraLinkEnrichmentData status = entry.getValue();
            Double fieldValue = (Double)this.fieldReader.getCustomFieldValueForIssueId(entry.getKey()).orNull();
            ProgressData selfProgress = ExtensionLinkProgress.createValueBasedSelfProgress(status, fieldValue);
            progressMap.put(entry.getKey(), selfProgress);
        }
        return progressMap;
    }

    public static SelfProgressExtractor createStoryPointExtractor(CustomFields customFields, Map<String, RetrievedJiraIssue> issues) throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        return new FieldBasedSelfProgressExtractor(FailSafeCustomFieldReader.createStoryPointReader(customFields, issues));
    }
}

