/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.AbstractWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.WarningType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnstructuredItemNotFullyScheduledWarning
extends AbstractWarning {
    private final float unscheduledWorkAmount;

    UnstructuredItemNotFullyScheduledWarning(String id, float unscheduledWorkAmount) {
        super(id);
        this.unscheduledWorkAmount = unscheduledWorkAmount;
    }

    public float getUnscheduledWorkAmount() {
        return this.unscheduledWorkAmount;
    }

    @Override
    public WarningType getWarningType() {
        return WarningType.NotFullyScheduled;
    }

    public static UnstructuredItemNotFullyScheduledWarning create(IItemAssignmentProblem assignmentProblem, @Nullable IUnstructuredItemSchedule schedule) {
        float openAmount = UnstructuredItemNotFullyScheduledWarning.calculateOpenAmount(assignmentProblem, schedule);
        return new UnstructuredItemNotFullyScheduledWarning(assignmentProblem.getId(), openAmount);
    }

    private static float calculateOpenAmount(IItemAssignmentProblem assignmentProblem, @Nullable IUnstructuredItemSchedule schedule) {
        float assignmentProblemWork = assignmentProblem.getProcessingItem().getWorkDemand().getPositiveTypeAmounts().getValueSum();
        if (schedule != null) {
            float scheduledAmount = schedule.getAggregatedWorkPackage().getPositiveTypeAmounts().getValueSum();
            return assignmentProblemWork - scheduledAmount;
        }
        return assignmentProblemWork;
    }
}

