/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.util.collection;

import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Set;

class FilteredKeysWrapper<K>
implements PositivePrimitivesMap<K> {
    private final PositivePrimitivesMap<K> wrapped;
    private final Set<K> filteredKeys;

    FilteredKeysWrapper(PositivePrimitivesMap<K> wrapped, Set<K> filteredKeys) {
        this.wrapped = wrapped;
        this.filteredKeys = filteredKeys;
    }

    @Override
    public Set<K> keySet() {
        return this.filteredKeys;
    }

    @Override
    public float get(K key) {
        if (!this.containsKey(key)) {
            return -2.1474836E9f;
        }
        return this.wrapped.get(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.filteredKeys.contains(key);
    }

    @Override
    public int size() {
        return this.filteredKeys.size();
    }

    @Override
    public float getValueSum() {
        float sum = 0.0f;
        for (K filteredKey : this.filteredKeys) {
            sum += this.wrapped.get(filteredKey);
        }
        return sum;
    }

    @Override
    public float getMinValue() {
        if (this.filteredKeys.isEmpty()) {
            return -2.1474836E9f;
        }
        float min = Float.MAX_VALUE;
        for (K filteredKey : this.filteredKeys) {
            float value = this.wrapped.get(filteredKey);
            min = Math.min(min, value);
        }
        return min;
    }

    @Override
    public float getMaxValue() {
        if (this.filteredKeys.isEmpty()) {
            return -2.1474836E9f;
        }
        float max = Float.MIN_VALUE;
        for (K filteredKey : this.filteredKeys) {
            float value = this.wrapped.get(filteredKey);
            max = Math.max(max, value);
        }
        return max;
    }

    @Override
    public boolean isEmpty() {
        return this.filteredKeys.isEmpty();
    }

    public static <K> PositivePrimitivesMap<K> create(PositivePrimitivesMap<K> inputMap, Predicate<K> predicate) {
        return new FilteredKeysWrapper<K>(inputMap, Sets.filter(inputMap.keySet(), predicate));
    }
}

