/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.PointCollectionFactory;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;

public class PGgeometryConverter {
    public static Geometry convert(org.geolatte.geom.Geometry geometry) {
        if (geometry instanceof org.geolatte.geom.Point) {
            return PGgeometryConverter.convert((org.geolatte.geom.Point)geometry);
        }
        if (geometry instanceof LinearRing) {
            return PGgeometryConverter.convert((LinearRing)geometry);
        }
        if (geometry instanceof org.geolatte.geom.LineString) {
            return PGgeometryConverter.convert((org.geolatte.geom.LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return PGgeometryConverter.convert((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return PGgeometryConverter.convert((Polygon)geometry);
        }
        if (geometry instanceof PolyHedralSurface) {
            return PGgeometryConverter.convert((PolyHedralSurface)geometry);
        }
        if (geometry instanceof org.geolatte.geom.MultiPoint) {
            return PGgeometryConverter.convert((org.geolatte.geom.MultiPoint)geometry);
        }
        if (geometry instanceof org.geolatte.geom.MultiPolygon) {
            return PGgeometryConverter.convert((org.geolatte.geom.MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return PGgeometryConverter.convert((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException(geometry.getClass().getName());
    }

    private static Point convert(org.geolatte.geom.Point point) {
        Point pgPoint = new Point();
        pgPoint.srid = point.getSRID();
        pgPoint.dimension = point.is3D() ? 3 : 2;
        pgPoint.haveMeasure = false;
        pgPoint.x = point.getX();
        pgPoint.y = point.getY();
        if (point.is3D()) {
            pgPoint.z = point.getZ();
        }
        if (point.isMeasured()) {
            pgPoint.m = point.getM();
            pgPoint.haveMeasure = true;
        }
        return pgPoint;
    }

    private static Point[] convertPoints(org.geolatte.geom.Geometry geometry) {
        Point[] pgPoints = new Point[geometry.getNumPoints()];
        for (int i = 0; i < pgPoints.length; ++i) {
            pgPoints[i] = PGgeometryConverter.convert(geometry.getPointN(i));
        }
        return pgPoints;
    }

    private static LineString convert(org.geolatte.geom.LineString lineString) {
        Point[] pgPoints = PGgeometryConverter.convertPoints((org.geolatte.geom.Geometry)lineString);
        LineString pgLineString = new LineString(pgPoints);
        pgLineString.haveMeasure = lineString.isMeasured();
        pgLineString.setSrid(lineString.getSRID());
        return pgLineString;
    }

    private static org.postgis.LinearRing convert(LinearRing linearRing) {
        Point[] pgPoints = PGgeometryConverter.convertPoints((org.geolatte.geom.Geometry)linearRing);
        org.postgis.LinearRing pgLinearRing = new org.postgis.LinearRing(pgPoints);
        pgLinearRing.haveMeasure = linearRing.isMeasured();
        pgLinearRing.setSrid(linearRing.getSRID());
        return pgLinearRing;
    }

    private static org.postgis.MultiLineString convert(MultiLineString multiLineString) {
        LineString[] pgLineStrings = new LineString[multiLineString.getNumGeometries()];
        for (int i = 0; i < pgLineStrings.length; ++i) {
            pgLineStrings[i] = PGgeometryConverter.convert(multiLineString.getGeometryN(i));
        }
        org.postgis.MultiLineString pgMultiLineString = new org.postgis.MultiLineString(pgLineStrings);
        pgMultiLineString.haveMeasure = multiLineString.isMeasured();
        pgMultiLineString.setSrid(multiLineString.getSRID());
        return pgMultiLineString;
    }

    private static org.postgis.Polygon convert(Polygon polygon) {
        int numRings = polygon.getNumInteriorRing();
        org.postgis.LinearRing[] rings = new org.postgis.LinearRing[numRings + 1];
        rings[0] = PGgeometryConverter.convert(polygon.getExteriorRing());
        for (int i = 0; i < numRings; ++i) {
            rings[i + 1] = PGgeometryConverter.convert(polygon.getInteriorRingN(i));
        }
        org.postgis.Polygon pgPolygon = new org.postgis.Polygon(rings);
        pgPolygon.setSrid(polygon.getSRID());
        return pgPolygon;
    }

    private static org.postgis.Polygon convert(PolyHedralSurface polyHedralSurface) {
        throw new UnsupportedOperationException();
    }

    private static MultiPoint convert(org.geolatte.geom.MultiPoint multiPoint) {
        Point[] pgPoints = PGgeometryConverter.convertPoints((org.geolatte.geom.Geometry)multiPoint);
        MultiPoint pgMultiPoint = new MultiPoint(pgPoints);
        pgMultiPoint.setSrid(multiPoint.getSRID());
        return pgMultiPoint;
    }

    private static MultiPolygon convert(org.geolatte.geom.MultiPolygon multiPolygon) {
        org.postgis.Polygon[] pgPolygons = new org.postgis.Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < pgPolygons.length; ++i) {
            pgPolygons[i] = PGgeometryConverter.convert(multiPolygon.getGeometryN(i));
        }
        MultiPolygon pgMultiPolygon = new MultiPolygon(pgPolygons);
        pgMultiPolygon.setSrid(multiPolygon.getSRID());
        return pgMultiPolygon;
    }

    private static org.postgis.GeometryCollection convert(GeometryCollection geometryCollection) {
        Geometry[] pgGeometries = new Geometry[geometryCollection.getNumGeometries()];
        for (int i = 0; i < pgGeometries.length; ++i) {
            pgGeometries[i] = PGgeometryConverter.convert(geometryCollection.getGeometryN(i));
        }
        org.postgis.GeometryCollection pgGeometryCollection = new org.postgis.GeometryCollection(pgGeometries);
        pgGeometryCollection.setSrid(geometryCollection.getSRID());
        return pgGeometryCollection;
    }

    public static org.geolatte.geom.Geometry convert(Geometry geometry) {
        switch (geometry.getType()) {
            case 1: {
                return PGgeometryConverter.convert((Point)geometry);
            }
            case 2: {
                return PGgeometryConverter.convert((LineString)geometry);
            }
            case 0: {
                return PGgeometryConverter.convert((org.postgis.LinearRing)geometry);
            }
            case 3: {
                return PGgeometryConverter.convert((org.postgis.Polygon)geometry);
            }
            case 5: {
                return PGgeometryConverter.convert((org.postgis.MultiLineString)geometry);
            }
            case 4: {
                return PGgeometryConverter.convert((MultiPoint)geometry);
            }
            case 6: {
                return PGgeometryConverter.convert((MultiPolygon)geometry);
            }
            case 7: {
                return PGgeometryConverter.convert((org.postgis.GeometryCollection)geometry);
            }
        }
        throw new IllegalArgumentException(geometry.toString());
    }

    private static org.geolatte.geom.Point convert(Point geometry) {
        int d = geometry.dimension;
        CrsId crs = CrsId.valueOf((int)geometry.srid);
        double[] point = new double[d + (geometry.haveMeasure ? 1 : 0)];
        int offset = 0;
        point[offset++] = geometry.x;
        point[offset++] = geometry.y;
        if (d == 3) {
            point[offset++] = geometry.z;
        }
        if (geometry.haveMeasure) {
            point[offset++] = geometry.m;
        }
        DimensionalFlag flag = DimensionalFlag.valueOf((d == 3 ? 1 : 0) != 0, (boolean)geometry.haveMeasure);
        return new org.geolatte.geom.Point(PointCollectionFactory.create((double[])point, (DimensionalFlag)flag, (CrsId)crs));
    }

    private static PointSequence convertPoints(Point[] points) {
        if (points.length == 0) {
            return PointCollectionFactory.createEmpty();
        }
        Point first = points[0];
        CrsId crs = CrsId.valueOf((int)first.srid);
        DimensionalFlag flag = DimensionalFlag.valueOf((first.dimension == 3 ? 1 : 0) != 0, (boolean)first.haveMeasure);
        PointSequenceBuilder pointSequence = PointSequenceBuilders.variableSized((DimensionalFlag)flag, (CrsId)crs);
        for (int i = 0; i < points.length; ++i) {
            pointSequence.add(PGgeometryConverter.convert(points[i]));
        }
        return pointSequence.toPointSequence();
    }

    private static GeometryCollection convert(org.postgis.GeometryCollection geometry) {
        org.geolatte.geom.Geometry[] geometries = new org.geolatte.geom.Geometry[geometry.numGeoms()];
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = PGgeometryConverter.convert(geometry.getSubGeometry(i));
        }
        return new GeometryCollection(geometries);
    }

    private static org.geolatte.geom.MultiPolygon convert(MultiPolygon geometry) {
        Polygon[] polygons = new Polygon[geometry.numPolygons()];
        for (int i = 0; i < polygons.length; ++i) {
            polygons[i] = PGgeometryConverter.convert(geometry.getPolygon(i));
        }
        return new org.geolatte.geom.MultiPolygon(polygons);
    }

    private static org.geolatte.geom.MultiPoint convert(MultiPoint geometry) {
        org.geolatte.geom.Point[] points = new org.geolatte.geom.Point[geometry.numPoints()];
        for (int i = 0; i < points.length; ++i) {
            points[i] = PGgeometryConverter.convert(geometry.getPoint(i));
        }
        return new org.geolatte.geom.MultiPoint(points);
    }

    private static MultiLineString convert(org.postgis.MultiLineString geometry) {
        org.geolatte.geom.LineString[] lineStrings = new org.geolatte.geom.LineString[geometry.numLines()];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = PGgeometryConverter.convert(geometry.getLine(i));
        }
        return new MultiLineString(lineStrings);
    }

    private static Polygon convert(org.postgis.Polygon geometry) {
        LinearRing[] rings = new LinearRing[geometry.numRings()];
        for (int i = 0; i < rings.length; ++i) {
            rings[i] = PGgeometryConverter.convert(geometry.getRing(i));
        }
        return new Polygon(rings);
    }

    private static LinearRing convert(org.postgis.LinearRing geometry) {
        PointSequence points = PGgeometryConverter.convertPoints(geometry.getPoints());
        return new LinearRing(points);
    }

    private static org.geolatte.geom.LineString convert(LineString geometry) {
        PointSequence points = PGgeometryConverter.convertPoints(geometry.getPoints());
        return new org.geolatte.geom.LineString(points);
    }

    private PGgeometryConverter() {
    }
}

