/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.collect.ImmutableList;
import com.mysema.query.QueryException;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExtractorVisitor;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.PredicateOperation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public final class ExpressionUtils {
    public static <T> Expression<T> all(CollectionExpression<?, ? super T> col) {
        return OperationImpl.create(col.getParameter(0), Ops.QuantOps.ALL, col);
    }

    public static <T> Expression<T> any(CollectionExpression<?, ? super T> col) {
        return OperationImpl.create(col.getParameter(0), Ops.QuantOps.ANY, col);
    }

    @Nullable
    public static Predicate allOf(Collection<Predicate> exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.and(rv, b);
        }
        return rv;
    }

    @Nullable
    public static Predicate allOf(Predicate ... exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.and(rv, b);
        }
        return rv;
    }

    public static Predicate and(Predicate left, Predicate right) {
        left = (Predicate)ExpressionUtils.extract(left);
        right = (Predicate)ExpressionUtils.extract(right);
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return PredicateOperation.create(Ops.AND, left, right);
    }

    @Nullable
    public static Predicate anyOf(Collection<Predicate> exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.or(rv, b);
        }
        return rv;
    }

    @Nullable
    public static Predicate anyOf(Predicate ... exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.or(rv, b);
        }
        return rv;
    }

    public static <D> Expression<D> as(Expression<D> source, Path<D> alias) {
        return OperationImpl.create(alias.getType(), Ops.ALIAS, source, alias);
    }

    public static <D> Expression<D> as(Expression<D> source, String alias) {
        return ExpressionUtils.as(source, new PathImpl<D>(source.getType(), alias));
    }

    public static Expression<Long> count(Expression<?> source) {
        return OperationImpl.create(Long.class, Ops.AggOps.COUNT_AGG, source);
    }

    public static <D> Predicate eqConst(Expression<D> left, D constant) {
        return ExpressionUtils.eq(left, ConstantImpl.create(constant));
    }

    public static <D> Predicate eq(Expression<D> left, Expression<? extends D> right) {
        return PredicateOperation.create(Ops.EQ, left, right);
    }

    public static <D> Predicate in(Expression<D> left, CollectionExpression<?, ? extends D> right) {
        return PredicateOperation.create(Ops.IN, left, right);
    }

    public static <D> Predicate in(Expression<D> left, Collection<? extends D> right) {
        if (right.size() == 1) {
            return ExpressionUtils.eqConst(left, right.iterator().next());
        }
        return PredicateOperation.create(Ops.IN, left, ConstantImpl.create(right));
    }

    public static Predicate isNull(Expression<?> left) {
        return PredicateOperation.create(Ops.IS_NULL, left);
    }

    public static Predicate isNotNull(Expression<?> left) {
        return PredicateOperation.create(Ops.IS_NOT_NULL, left);
    }

    public static Expression<String> likeToRegex(Expression<String> expr) {
        return ExpressionUtils.likeToRegex(expr, true);
    }

    public static Expression<String> likeToRegex(Expression<String> expr, boolean matchStartAndEnd) {
        Operation o;
        if (expr instanceof Constant) {
            String like = expr.toString();
            StringBuilder rv = new StringBuilder(like.length() + 4);
            if (matchStartAndEnd && !like.startsWith("%")) {
                rv.append('^');
            }
            for (int i = 0; i < like.length(); ++i) {
                char ch = like.charAt(i);
                if (ch == '.' || ch == '*' || ch == '?') {
                    rv.append('\\');
                } else {
                    if (ch == '%') {
                        rv.append(".*");
                        continue;
                    }
                    if (ch == '_') {
                        rv.append('.');
                        continue;
                    }
                }
                rv.append(ch);
            }
            if (matchStartAndEnd && !like.endsWith("%")) {
                rv.append('$');
            }
            if (!like.equals(rv.toString())) {
                return ConstantImpl.create(rv.toString());
            }
        } else if (expr instanceof Operation && (o = (Operation)expr).getOperator() == Ops.CONCAT) {
            Expression<String> lhs = ExpressionUtils.likeToRegex(o.getArg(0), false);
            Expression<String> rhs = ExpressionUtils.likeToRegex(o.getArg(1), false);
            if (lhs != o.getArg(0) || rhs != o.getArg(1)) {
                return OperationImpl.create(String.class, Ops.CONCAT, lhs, rhs);
            }
        }
        return expr;
    }

    public static <T> Expression<T> list(Class<T> clazz, Expression<?> ... exprs) {
        return ExpressionUtils.list(clazz, ImmutableList.copyOf((Object[])exprs));
    }

    public static <T> Expression<T> list(Class<T> clazz, List<? extends Expression<?>> exprs) {
        Expression<?> rv = exprs.get(0);
        if (exprs.size() == 1) {
            rv = OperationImpl.create(clazz, Ops.SINGLETON, rv, exprs.get(0));
        } else {
            for (int i = 1; i < exprs.size(); ++i) {
                rv = OperationImpl.create(clazz, Ops.LIST, rv, exprs.get(i));
            }
        }
        return rv;
    }

    public static Expression<String> regexToLike(Expression<String> expr) {
        Operation o;
        if (expr instanceof Constant) {
            String str = expr.toString();
            StringBuilder rv = new StringBuilder(str.length() + 2);
            boolean escape = false;
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (!escape && ch == '.') {
                    if (i < str.length() - 1 && str.charAt(i + 1) == '*') {
                        rv.append('%');
                        ++i;
                        continue;
                    }
                    rv.append('_');
                    continue;
                }
                if (!escape && ch == '\\') {
                    escape = true;
                    continue;
                }
                if (!(escape || ch != '[' && ch != ']' && ch != '^' && ch != '.' && ch != '*')) {
                    throw new QueryException("'" + str + "' can't be converted to like form");
                }
                if (escape && (ch == 'd' || ch == 'D' || ch == 's' || ch == 'S' || ch == 'w' || ch == 'W')) {
                    throw new QueryException("'" + str + "' can't be converted to like form");
                }
                rv.append(ch);
                escape = false;
            }
            if (!rv.toString().equals(str)) {
                return ConstantImpl.create(rv.toString());
            }
        } else if (expr instanceof Operation && (o = (Operation)expr).getOperator() == Ops.CONCAT) {
            Expression<String> lhs = ExpressionUtils.regexToLike(o.getArg(0));
            Expression<String> rhs = ExpressionUtils.regexToLike(o.getArg(1));
            if (lhs != o.getArg(0) || rhs != o.getArg(1)) {
                return OperationImpl.create(String.class, Ops.CONCAT, lhs, rhs);
            }
        }
        return expr;
    }

    public static <D> Predicate neConst(Expression<D> left, D constant) {
        return ExpressionUtils.ne(left, ConstantImpl.create(constant));
    }

    public static <D> Predicate ne(Expression<D> left, Expression<? super D> right) {
        return PredicateOperation.create(Ops.NE, left, right);
    }

    public static Predicate or(Predicate left, Predicate right) {
        left = (Predicate)ExpressionUtils.extract(left);
        right = (Predicate)ExpressionUtils.extract(right);
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return PredicateOperation.create(Ops.OR, left, right);
    }

    public static ImmutableList<Expression<?>> distinctList(Expression<?> ... args) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet set = new HashSet(args.length);
        for (Expression<?> arg : args) {
            if (!set.add(arg)) continue;
            builder.add(arg);
        }
        return builder.build();
    }

    public static ImmutableList<Expression<?>> distinctList(Expression<?>[] ... args) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet set = new HashSet();
        Expression<?>[][] arr$ = args;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Expression<?>[] arr;
            for (Expression<?> arg : arr = arr$[i$]) {
                if (!set.add(arg)) continue;
                builder.add(arg);
            }
        }
        return builder.build();
    }

    public static <T> Expression<T> extract(Expression<T> expr) {
        if (expr != null) {
            Class<?> clazz = expr.getClass();
            if (clazz == PathImpl.class || clazz == PredicateOperation.class || clazz == ConstantImpl.class) {
                return expr;
            }
            return (Expression)expr.accept(ExtractorVisitor.DEFAULT, null);
        }
        return null;
    }

    private ExpressionUtils() {
    }
}

