/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.sql;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.AOEstimate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimateBlock;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EstimateSelectSQL
extends BaseAOPersistenceSQL {
    public EstimateSelectSQL(ActiveObjectsUtilities utils) {
        super(utils);
    }

    public List<IEstimate> getAllEstimates(final String id, DataMode dataMode) throws Exception {
        final boolean replanning = dataMode == DataMode.Replanning;
        final boolean original = dataMode == DataMode.Original;
        return this.sql(new IQuery<List<IEstimate>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "estimate").select().col("estimate", "estimate").col("estimate", "targetId").col("estimate", "ID_OTHER", false).col("estimate", "targetType").from("estimate").where().col("estimate", "aoworkitem").eq().numeric(id).and().col("estimate", "replanning").eq().bool(replanning).and().col("estimate", "original").eq().bool(original).orderBy().raw("CASE WHEN ").col("estimate", "targetType").eq().str("total").raw("THEN 0").raw("WHEN ").col("estimate", "targetType").eq().str("stage").raw("THEN 1").raw("ELSE 2 END");
            }

            @Override
            public List<IEstimate> handleResult(ResultSet set) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (set.next()) {
                    RestEstimate estimate = new RestEstimate(BaseAOPersistenceSQL.getDouble(set, 1));
                    estimate.setTargetId(BaseAOPersistenceSQL.getInt(set, 2));
                    estimate.setId(BaseAOPersistenceSQL.getString(set, 3));
                    estimate.setTargetType(BaseAOPersistenceSQL.getString(set, 4));
                    retVal.add(estimate);
                }
                return retVal;
            }
        });
    }

    public Optional<IEstimate> getTotalEstimate(String id, DataMode dataMode) throws Exception {
        List<IEstimate> total = this.getEstimatesOfType(id, "total", dataMode);
        if (total.size() > 0) {
            return Optional.fromNullable((Object)total.get(0));
        }
        return Optional.absent();
    }

    public List<IEstimate> getEstimatesOfType(final String id, final String type, DataMode dataMode) throws Exception {
        final boolean replanning = dataMode == DataMode.Replanning;
        final boolean original = dataMode == DataMode.Original;
        return this.sql(new IQuery<List<IEstimate>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "estimate").select().col("estimate", "estimate").col("estimate", "targetId").col("estimate", "ID_OTHER", false).from("estimate").where().col("estimate", "aoworkitem").eq().numeric(id).and().col("estimate", "targetType").eq().str(type).and().col("estimate", "replanning").eq().bool(replanning).and().col("estimate", "original").eq().bool(original);
            }

            @Override
            public List<IEstimate> handleResult(ResultSet set) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (set.next()) {
                    RestEstimate estimate = new RestEstimate(set.getDouble(1));
                    estimate.setTargetId(set.getInt(2));
                    estimate.setId(set.getString(3));
                    retVal.add(estimate);
                }
                return retVal;
            }
        });
    }

    public Map<String, Map<DataMode, IEstimateBlock>> getRemainingAndOriginalEstimates(final Collection<String> workItemIDs) throws SQLException {
        return this.sql(new IQuery<Map<String, Map<DataMode, IEstimateBlock>>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                String estimate = "estimate";
                String workItem = "workItem";
                generator.withTable(AOWorkItem.class, "workItem").withTable(AOEstimate.class, "estimate").select().colId("workItem").col("workItem", "hasOriginalEstimates").col("estimate", "estimate").col("estimate", "targetType").col("estimate", "targetId").col("estimate", "original").from("workItem").leftJoin().table("estimate").on().colId("workItem").eq().col("estimate", "aoWorkItem").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("workItem");
                    }
                }, workItemIDs).and().raw("(").col("estimate", "replanning").isNull().or().col("estimate", "replanning").eq().bool(false).raw(")");
            }

            @Override
            public Map<String, Map<DataMode, IEstimateBlock>> handleResult(ResultSet set) throws Exception {
                HashMap retVal = Maps.newHashMap();
                HashSet originalEstimateItems = Sets.newHashSet();
                while (set.next()) {
                    Map estimatesForWorkItem;
                    String workItemID = BaseAOPersistenceSQL.getString(set, 1);
                    Boolean hasOriginalEstimates = BaseAOPersistenceSQL.getBoolean(set, 2);
                    Double estimateValue = BaseAOPersistenceSQL.getDouble(set, 3);
                    String targetType = BaseAOPersistenceSQL.getString(set, 4);
                    Integer targetId = EstimateSelectSQL.getInteger(set, 5);
                    Boolean isOriginalEstimate = BaseAOPersistenceSQL.getBoolean(set, 6);
                    if (Boolean.TRUE.equals(hasOriginalEstimates)) {
                        originalEstimateItems.add(workItemID);
                    }
                    if ((estimatesForWorkItem = (Map)retVal.get(workItemID)) == null) {
                        estimatesForWorkItem = Maps.newHashMap();
                        retVal.put(workItemID, estimatesForWorkItem);
                    }
                    if (targetType == null) continue;
                    DataMode dataMode = Boolean.TRUE.equals(isOriginalEstimate) ? DataMode.Original : DataMode.Default;
                    IEstimateBlock estimateBlock = (IEstimateBlock)estimatesForWorkItem.get((Object)dataMode);
                    if (estimateBlock == null) {
                        estimateBlock = new RestEstimateBlock();
                        estimatesForWorkItem.put(dataMode, estimateBlock);
                    }
                    RestEstimate estimate = new RestEstimate(estimateValue);
                    estimate.setTargetId(targetId);
                    if ("total".equals(targetType)) {
                        estimateBlock.setTotal(estimate);
                        continue;
                    }
                    if ("stage".equals(targetType)) {
                        estimateBlock.addStageEstimate(estimate);
                        continue;
                    }
                    if (!"skill".equals(targetType)) continue;
                    estimateBlock.addSkillEstimate(estimate);
                }
                for (String workItemId : originalEstimateItems) {
                    Map estimates = (Map)retVal.get(workItemId);
                    IEstimateBlock estimateBlock = (IEstimateBlock)estimates.get((Object)DataMode.Original);
                    if (estimateBlock != null) continue;
                    estimateBlock = new RestEstimateBlock();
                    estimateBlock.setTotal(new RestEstimate(0.0));
                    estimates.put(DataMode.Original, estimateBlock);
                }
                return retVal;
            }
        });
    }
}

