/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimateTableHelper;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationTargetType;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ResultSetParsingUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
class EstimationDataBlockReader {
    private static final Log LOGGER = Log.with(EstimationDataBlockReader.class);
    private static final Map<String, Integer> INDICES = Maps.newHashMap();

    EstimationDataBlockReader() {
    }

    Optional<EstimationDataBlock> readRowData(ResultSet resultSet, int offset) throws SQLException {
        LOGGER.debug("read estimation block from result set: %s", resultSet);
        String targetType = resultSet.getString(offset + EstimationDataBlockReader.getColumnIndex("targetType"));
        if (targetType == null) {
            LOGGER.debug("encountered empty estimation type", new Object[0]);
            return Optional.absent();
        }
        double estimate = resultSet.getDouble(offset + EstimationDataBlockReader.getColumnIndex("estimate"));
        Boolean original = (Boolean)ResultSetParsingUtils.getOptionalBoolean(resultSet, offset + EstimationDataBlockReader.getColumnIndex("original")).orNull();
        Boolean replanning = (Boolean)ResultSetParsingUtils.getOptionalBoolean(resultSet, offset + EstimationDataBlockReader.getColumnIndex("replanning")).orNull();
        int targetId = resultSet.getInt(offset + EstimationDataBlockReader.getColumnIndex("targetId"));
        EstimationDataBlock estimationBlock = new EstimationDataBlock(estimate, targetId, EstimationTargetType.valueOf(targetType), original, replanning);
        LOGGER.debug("read estimation block: %s", estimationBlock);
        return Optional.of((Object)estimationBlock);
    }

    private static Integer getColumnIndex(String column) {
        return INDICES.get(column) + 1;
    }

    static {
        for (int i = 0; i < EstimateTableHelper.COLUMNS.size(); ++i) {
            INDICES.put(EstimateTableHelper.COLUMNS.get(i), i);
        }
    }
}

