/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGeneratorFactory;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IInsert;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IVoidQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.dbutils.DbUtils;

public abstract class BaseAOPersistenceSQL {
    private static final Log LOGGER = Log.with(BaseAOPersistenceSQL.class);
    private static final String QUERY_LOG_PATTERN = "%dms (C: %d, G: %d, X: %d, R: %d) | \t%s";
    private static final long SLOW_QUERY_EXECUTION_TIME = 500L;
    private ActiveObjectsUtilities activeObjectsUtilities;

    public BaseAOPersistenceSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        this.activeObjectsUtilities = activeObjectsUtilities;
    }

    private static void logQuery(Object callback, long totalTime, long initConnectionTime, long queryGenerationTime, long executionTime, long resultHandlingTime, String query, String additionalInfo, Connection connection) {
        try {
            if (executionTime > 500L) {
                String outputString = String.format(QUERY_LOG_PATTERN, totalTime, initConnectionTime, queryGenerationTime, executionTime, resultHandlingTime, query);
                LOGGER.info("long running db query.", new Object[0]);
                LOGGER.info("query class: %s", callback.getClass().getEnclosingClass());
                LOGGER.info(connection.getMetaData().getURL(), new Object[0]);
                LOGGER.info(outputString, new Object[0]);
                if (additionalInfo != null) {
                    additionalInfo = additionalInfo.replace("%", "%%");
                    LOGGER.info(additionalInfo, new Object[0]);
                }
            } else {
                Log logger = Log.with(callback.getClass().getEnclosingClass());
                if (logger.isDebugEnabled()) {
                    String outputString = String.format(QUERY_LOG_PATTERN, totalTime, initConnectionTime, queryGenerationTime, executionTime, resultHandlingTime, query);
                    logger.debug(connection.getMetaData().getURL(), new Object[0]);
                    logger.debug(outputString, new Object[0]);
                    if (additionalInfo != null) {
                        logger.debug(additionalInfo, new Object[0]);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void logQueryError(Object callback, String query, String additionalInfo, Exception cause) {
        block10: {
            try {
                if (additionalInfo != null) {
                    additionalInfo = additionalInfo.replace("%", "%%");
                }
                Log logger = Log.with(callback.getClass().getEnclosingClass());
                if (query != null) {
                    logger.error(query, new Object[0]);
                } else {
                    logger.error("Failed to build query. Query was null.", new Object[0]);
                }
                if (additionalInfo != null) {
                    logger.error(additionalInfo, new Object[0]);
                }
                if (cause != null) {
                    logger.exception(cause);
                }
            }
            catch (Exception ex) {
                if (query != null) {
                    LOGGER.error(query, new Object[0]);
                } else {
                    LOGGER.error("Failed to build query. Query was null.", new Object[0]);
                }
                if (additionalInfo != null) {
                    LOGGER.error(additionalInfo, new Object[0]);
                }
                if (cause == null) break block10;
                LOGGER.exception(cause);
            }
        }
    }

    protected void sql(final IVoidQuery sql) throws SQLException {
        this.sql(new IQuery<Void>(){

            @Override
            public void sql(AOQueryGenerator query) throws Exception {
                sql.sql(query);
            }

            @Override
            public Void handleResult(ResultSet result) throws Exception {
                sql.handleResult(result);
                return null;
            }
        });
    }

    protected String sql(IInsert callback) throws SQLException {
        return this.sql(callback, this.activeObjectsUtilities.getOrCreateConnection());
    }

    protected String sql(IInsert callback, Connection connection) throws SQLException {
        return this.sql(callback, connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String sql(IInsert callback, Connection connection, boolean closeConnection) throws SQLException {
        statement = null;
        generatedKeys = null;
        query = null;
        additionalData = null;
        startTime = System.currentTimeMillis();
        try {
            generator = AOQueryGeneratorFactory.create(connection, this.activeObjectsUtilities);
            initConnectionTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            callback.sql(generator);
            query = generator.getSql();
            additionalData = generator.getParameterAsReadableString();
            queryGenerationTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            meta = connection.getMetaData();
            databaseType = meta.getDatabaseProductName().toLowerCase();
            key = null;
            if (databaseType.contains("hsql") && meta.getDatabaseMajorVersion() < 2) {
                statement = generator.generateStatement(connection, new String[0]);
                statement.executeUpdate();
                executionTime = System.currentTimeMillis() - startTime;
                identityStatement = connection.createStatement();
                try {
                    generatedKeys = identityStatement.executeQuery("CALL IDENTITY()");
                    if (!generatedKeys.next()) ** GOTO lbl39
                    key = BaseAOPersistenceSQL.getString(generatedKeys, 1);
                }
                finally {
                    DbUtils.closeQuietly(identityStatement);
                }
            } else {
                statement = generator.generateStatement(connection, new String[]{"ID_OTHER"});
                statement.executeUpdate();
                executionTime = System.currentTimeMillis() - startTime;
                generatedKeys = statement.getGeneratedKeys();
                if (generatedKeys.next()) {
                    key = String.valueOf(BaseAOPersistenceSQL.getLong(generatedKeys, 1));
                }
            }
lbl39:
            // 5 sources

            callback.handleResult(key);
            totalTime = initConnectionTime + queryGenerationTime + executionTime;
            BaseAOPersistenceSQL.logQuery(callback, totalTime, initConnectionTime, queryGenerationTime, executionTime, 0L, query, additionalData, connection);
            var22_17 = key;
        }
        catch (Exception ex) {
            try {
                BaseAOPersistenceSQL.logQueryError(callback, query, additionalData, ex);
                throw new SQLException("Failed to execute SQL [" + query + " ] ", ex);
            }
            catch (Throwable var24_20) {
                DbUtils.closeQuietly(generatedKeys);
                DbUtils.closeQuietly(statement);
                if (closeConnection) {
                    DbUtils.closeQuietly(connection);
                }
                throw var24_20;
            }
        }
        DbUtils.closeQuietly(generatedKeys);
        DbUtils.closeQuietly(statement);
        if (closeConnection) {
            DbUtils.closeQuietly(connection);
        }
        return var22_17;
    }

    protected <TReturnValue> TReturnValue sql(IQuery<TReturnValue> callback) throws SQLException {
        return this.sql(callback, this.activeObjectsUtilities.getOrCreateConnection());
    }

    protected <TReturnValue> TReturnValue sql(IQuery<TReturnValue> callback, Connection connection) throws SQLException {
        return this.sql(callback, connection, true);
    }

    protected <TReturnValue> TReturnValue sql(IQuery<TReturnValue> callback, Connection connection, boolean closeConnection) throws SQLException {
        TReturnValue TReturnValue;
        PreparedStatement statement = null;
        ResultSet set = null;
        String query = null;
        String additionalData = null;
        long startTime = System.currentTimeMillis();
        try {
            AOQueryGenerator generator = AOQueryGeneratorFactory.create(connection, this.activeObjectsUtilities);
            long initConnectionTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            callback.sql(generator);
            query = generator.getSql();
            additionalData = generator.getParameterAsReadableString();
            long queryGenerationTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            statement = generator.generateStatement(connection, new String[0]);
            set = statement.executeQuery();
            long executionTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            TReturnValue retVal = callback.handleResult(set);
            long resultHandlingTime = System.currentTimeMillis() - startTime;
            long totalTime = initConnectionTime + queryGenerationTime + executionTime + resultHandlingTime;
            BaseAOPersistenceSQL.logQuery(callback, totalTime, initConnectionTime, queryGenerationTime, executionTime, resultHandlingTime, query, additionalData, connection);
            TReturnValue = retVal;
        }
        catch (Exception ex) {
            try {
                BaseAOPersistenceSQL.logQueryError(callback, query, additionalData, ex);
                throw new SQLException("Failed to execute SQL [" + query + " ] ", ex);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(set);
                DbUtils.closeQuietly(statement);
                if (closeConnection) {
                    DbUtils.closeQuietly(connection);
                }
                throw throwable;
            }
        }
        DbUtils.closeQuietly(set);
        DbUtils.closeQuietly(statement);
        if (closeConnection) {
            DbUtils.closeQuietly(connection);
        }
        return TReturnValue;
    }

    protected void sql(IUpdate callback) throws SQLException {
        this.sql(callback, this.activeObjectsUtilities.getOrCreateConnection());
    }

    protected void sql(IUpdate callback, Connection connection) throws SQLException {
        this.sql(callback, connection, true);
    }

    protected void sql(IUpdate callback, Connection connection, boolean closeConnection) throws SQLException {
        if (connection == null) {
            connection = this.activeObjectsUtilities.getOrCreateConnection();
            closeConnection = true;
        }
        PreparedStatement statement = null;
        String query = null;
        String additionalData = null;
        long startTime = System.currentTimeMillis();
        try {
            AOQueryGenerator generator = AOQueryGeneratorFactory.create(connection, this.activeObjectsUtilities);
            long initConnectionTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            callback.sql(generator);
            query = generator.getSql();
            additionalData = generator.getParameterAsReadableString();
            long queryGenerationTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            statement = generator.generateStatement(connection, new String[0]);
            statement.executeUpdate();
            long executionTime = System.currentTimeMillis() - startTime;
            long totalTime = initConnectionTime + queryGenerationTime + executionTime;
            BaseAOPersistenceSQL.logQuery(callback, totalTime, initConnectionTime, queryGenerationTime, executionTime, 0L, query, additionalData, connection);
        }
        catch (Exception ex) {
            try {
                BaseAOPersistenceSQL.logQueryError(callback, query, additionalData, ex);
                throw new SQLException("Failed to execute SQL [" + query + " ] ", ex);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                if (closeConnection) {
                    DbUtils.closeQuietly(connection);
                }
                throw throwable;
            }
        }
        DbUtils.closeQuietly(statement);
        if (closeConnection) {
            DbUtils.closeQuietly(connection);
        }
    }

    public static String getString(ResultSet resultSet, int column) throws SQLException {
        String retVal = resultSet.getString(column);
        if (resultSet.wasNull()) {
            retVal = null;
        } else if ("".equals(retVal)) {
            retVal = null;
        }
        return retVal;
    }

    public static Integer getInt(ResultSet resultSet, int column) throws SQLException {
        Integer retVal = resultSet.getInt(column);
        if (resultSet.wasNull()) {
            retVal = null;
        }
        return retVal;
    }

    public static Boolean getBoolean(ResultSet resultSet, int column) throws SQLException {
        Boolean retVal = resultSet.getBoolean(column);
        if (resultSet.wasNull()) {
            retVal = null;
        }
        return retVal;
    }

    public static Double getDouble(ResultSet resultSet, int column) throws SQLException {
        Double retVal = resultSet.getDouble(column);
        if (resultSet.wasNull()) {
            retVal = null;
        }
        return retVal;
    }

    protected static Long getLong(ResultSet resultSet, int column) throws SQLException {
        Long retVal = resultSet.getLong(column);
        if (resultSet.wasNull()) {
            retVal = null;
        }
        return retVal;
    }

    protected static Integer getInteger(ResultSet resultSet, int column) throws SQLException {
        Integer retVal = resultSet.getInt(column);
        if (resultSet.wasNull()) {
            retVal = null;
        }
        return retVal;
    }

    @Deprecated
    protected static void printResultSet(ResultSet set) throws Exception {
        int i;
        ResultSetMetaData rsmd = set.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        for (i = 1; i <= numberOfColumns; ++i) {
            if (i > 1) {
                System.out.print(",  ");
            }
            String columnName = rsmd.getColumnName(i);
            System.out.print(columnName);
        }
        System.out.println("");
        while (set.next()) {
            for (i = 1; i <= numberOfColumns; ++i) {
                if (i > 1) {
                    System.out.print(",  ");
                }
                String columnValue = set.getString(i);
                System.out.print(columnValue);
            }
            System.out.println("");
        }
    }
}

