/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync.releases;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.extensions.releases.VersionsBulkSyncRequest;
import com.radiantminds.roadmap.common.handlers.sync.releases.ReleaseNameUtil;
import com.radiantminds.roadmap.common.handlers.sync.releases.ValidReleaseSyncRequest;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSolutionInterval;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class VersionsBulkSyncRequestImpl
implements VersionsBulkSyncRequest {
    private final Set<String> links;
    private final ValidReleaseSyncRequest syncRequest;
    private final Long startDate;
    private final Long releaseDate;
    private final String name;

    public VersionsBulkSyncRequestImpl(Set<String> links, ValidReleaseSyncRequest syncRequest, Long startDate, Long releaseDate, String name) {
        this.links = links;
        this.startDate = startDate;
        this.releaseDate = releaseDate;
        this.name = name;
        this.syncRequest = syncRequest;
    }

    @Override
    public boolean isSyncStartDate() {
        return this.syncRequest.isSyncStartDate();
    }

    @Override
    public Set<String> getExtensionLinks() {
        return this.links;
    }

    @Override
    public boolean isSyncTimeData() {
        return this.syncRequest.isSyncStartDate() || this.syncRequest.isSyncReleaseDate();
    }

    @Override
    public boolean isTimeDataValid() {
        if (this.startDate == null || this.releaseDate == null) {
            return true;
        }
        return this.startDate <= this.releaseDate;
    }

    @Override
    public Long getStartDate() {
        return this.startDate;
    }

    @Override
    public boolean isSyncReleaseDate() {
        return this.syncRequest.isSyncReleaseDate();
    }

    @Override
    public Long getReleaseDate() {
        return this.releaseDate;
    }

    @Override
    public boolean isSyncName() {
        return this.syncRequest.isSyncName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    static VersionsBulkSyncRequest create(IRelease release, IStream stream, ValidReleaseSyncRequest syncRequest, @Nullable RestSchedulingSolution solution) {
        boolean isLaterRelease;
        Set<String> links = VersionsBulkSyncRequestImpl.getLinks(release.getExtensionLinks());
        RestSolutionInterval releaseInterval = null;
        boolean bl = isLaterRelease = release.getIsLaterRelease() != null && release.getIsLaterRelease() != false;
        if (solution != null) {
            releaseInterval = solution.getCalculatedReleaseInterval(release.getId());
        }
        Long startTime = null;
        if (syncRequest.isSyncStartDate() && (startTime = (Long)release.getFixedStartDate().orNull()) == null && solution != null && releaseInterval != null && releaseInterval.getStart() != null) {
            startTime = releaseInterval.getStart();
        }
        Long releaseTime = null;
        if (syncRequest.isSyncReleaseDate()) {
            Long l = releaseTime = isLaterRelease ? null : (Long)release.getFixedEndDate().orNull();
            if (releaseTime == null && solution != null && releaseInterval != null && releaseInterval.getEnd() != null) {
                releaseTime = releaseInterval.getEnd();
            }
        }
        String name = ReleaseNameUtil.getReleaseName(release, stream);
        VersionsBulkSyncRequestImpl instance = new VersionsBulkSyncRequestImpl(links, syncRequest, startTime, releaseTime, name);
        return instance;
    }

    private static Set<String> getLinks(List<IExtensionLink> extensionLinks) {
        HashSet links = Sets.newHashSet();
        if (extensionLinks == null) {
            return links;
        }
        for (IExtensionLink extensionLink : extensionLinks) {
            links.add(extensionLink.getExtensionLink());
        }
        return links;
    }
}

