/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.common;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessage;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestItemResult {
    @XmlElement
    private String id;
    @XmlElement
    private ModificationResult item;
    @XmlElement
    private String error;
    @XmlElement
    private List<RestMessage> warnings;

    @Deprecated
    private RestItemResult() {
    }

    public RestItemResult(String id, ModificationResult item) {
        this.id = id;
        this.item = item;
    }

    public RestItemResult(String id) {
        this.id = id;
    }

    public RestItemResult(String id, String error) {
        this.id = id;
        this.error = error;
    }

    public RestItemResult(String id, String error, List<RestMessage> warnings) {
        this.id = id;
        this.error = error;
        this.warnings = warnings != null ? Lists.newArrayList(warnings) : null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ModificationResult getItem() {
        return this.item;
    }

    public void setItem(ModificationResult item) {
        this.item = item;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public List<RestMessage> getWarnings() {
        if (this.warnings == null) {
            return null;
        }
        return Collections.unmodifiableList(this.warnings);
    }

    public void addWarning(RestMessage warning) {
        if (this.warnings == null) {
            this.warnings = Lists.newArrayList();
        }
        this.warnings.add(warning);
    }
}

