/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.permissions;

import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.permissions.RestPermission;
import com.radiantminds.roadmap.common.rest.services.permissions.PluginPermissionServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/systempermissions")
@WebSudoRequired
@Component
public class PluginPermissionService {
    private final PluginPermissionServiceHandler handler;
    private final PortfolioPermissionPersistence permissionPersistence;

    @Autowired
    public PluginPermissionService(SecuredInvocationHandlerFactory handlerFactory, PortfolioPermissionPersistence permissionPersistence, UserExtension userExtension) {
        this.handler = handlerFactory.createProxy(PluginPermissionServiceHandler.class, new PluginPermissionServiceHandler.Impl(permissionPersistence, userExtension));
        this.permissionPersistence = permissionPersistence;
    }

    @POST
    public Response setPermission(RestPermission permission) throws Exception {
        return this.handler.setPermission(permission);
    }

    @DELETE
    @Path(value="{id}")
    public Response deletePermission(@PathParam(value="id") String permissionId) throws Exception {
        return this.handler.deletePermission(permissionId);
    }

    @GET
    @Path(value="{targetId}")
    public Response getPermissions(@PathParam(value="targetId") String targetId) throws Exception {
        return this.handler.getPermissions(targetId);
    }
}

