/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.scheduling;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSolutionState;
import com.radiantminds.roadmap.common.rest.exceptions.PluginServerInfoProvider;
import com.radiantminds.roadmap.common.rest.exceptions.ServerInfoProvider;
import com.radiantminds.roadmap.common.scheduling.Calculation;
import com.radiantminds.roadmap.common.scheduling.CalculationState;
import com.radiantminds.roadmap.common.scheduling.ISolutionCallback;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import javax.ws.rs.core.Response;

public interface SchedulingServiceHandler {
    @AuthorizedPlanReadAccess
    public Response triggerScheduling(EntityContext<IPlan> var1) throws Exception;

    @AuthorizedPlanReadAccess
    public Response cancelScheduling(EntityContext<IPlan> var1) throws Exception;

    @AuthorizedPlanReadAccess
    public Response getSolutionState(EntityContext<IPlan> var1) throws Exception;

    public static class Impl
    implements SchedulingServiceHandler {
        private final ServerInfoProvider serverInfoProvider;
        private final FeatureExtension featureExtension;
        private final Scheduling scheduling;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, FeatureExtension featureExtension, Scheduling scheduling) {
            this.scheduling = scheduling;
            this.serverInfoProvider = new PluginServerInfoProvider(activeObjectsUtilities);
            this.featureExtension = featureExtension;
        }

        @Override
        public Response triggerScheduling(EntityContext<IPlan> entityContext) throws Exception {
            this.scheduling.triggerSolution(entityContext.getEntityId());
            return this.buildStateOrSolutionResponse(entityContext.getEntityId());
        }

        @Override
        public Response cancelScheduling(EntityContext<IPlan> entityContext) throws Exception {
            final Optional<Calculation> calculation = this.scheduling.getSolutionForPlan(entityContext.getEntityId());
            if (!calculation.isPresent()) {
                return ResponseBuilder.notFound();
            }
            return this.getForCalculation((Calculation)calculation.get(), new ISolutionCallback<Response>(){

                @Override
                public Response execute(RestSolutionState state, RestSchedulingSolution transferrableSolution) {
                    if (state.getState() == CalculationState.IN_PROGRESS) {
                        CalculationState cancellationState = ((Calculation)calculation.get()).cancel();
                        return ResponseBuilder.ok(new RestSolutionState(state.getSolutionVersion(), cancellationState));
                    }
                    return ResponseBuilder.ok(state);
                }
            });
        }

        @Override
        public Response getSolutionState(EntityContext<IPlan> entityContext) throws Exception {
            return this.buildStateOrSolutionResponse(entityContext.getEntityId());
        }

        private Response buildStateOrSolutionResponse(String planId) {
            Optional<Calculation> calculation = this.scheduling.getSolutionForPlan(planId);
            if (!calculation.isPresent()) {
                return ResponseBuilder.notFound();
            }
            return this.getForCalculation((Calculation)calculation.get(), new ISolutionCallback<Response>(){

                @Override
                public Response execute(RestSolutionState state, RestSchedulingSolution transferrableSolution) {
                    if (state.getState() == CalculationState.DONE) {
                        return ResponseBuilder.ok(transferrableSolution);
                    }
                    if (state.getState() == CalculationState.UNKNOWN) {
                        return ResponseBuilder.notFound();
                    }
                    return ResponseBuilder.ok(state);
                }
            });
        }

        private Response getForCalculation(Calculation calculation, ISolutionCallback<Response> callback) {
            Optional serverInfoProvider = this.featureExtension.isErrorServerDetailsEnabled() ? Optional.fromNullable((Object)this.serverInfoProvider) : Optional.absent();
            return calculation.withCalculationLock((Optional<ServerInfoProvider>)serverInfoProvider, callback);
        }
    }
}

