/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISchedulingAssignment;
import org.joda.time.Interval;

public class WorkAssignmentWrapper
implements ISchedulingAssignment {
    private final IWorkAssignment workAssignment;
    private final ITimeTransformer timeTransformer;

    public WorkAssignmentWrapper(IWorkAssignment workAssignment, ITimeTransformer timeTransformer) {
        this.workAssignment = (IWorkAssignment)Preconditions.checkNotNull((Object)workAssignment);
        this.timeTransformer = (ITimeTransformer)Preconditions.checkNotNull((Object)timeTransformer);
    }

    @Override
    public String getResourceId() {
        return this.workAssignment.getResource().getId();
    }

    @Override
    public String getTeamId() {
        return this.workAssignment.getResourceGroup().getId();
    }

    @Override
    public String getWorkItemId() {
        return this.workAssignment.getItemId();
    }

    @Override
    public String getSkillId() {
        return this.workAssignment.getResourceType().getId();
    }

    @Override
    public String getReleaseId() {
        return this.workAssignment.getProjectEpisode().getId();
    }

    @Override
    public Interval getWorkInterval() {
        return this.timeTransformer.transformInterval(this.workAssignment.getWorkSlot());
    }

    @Override
    public int getSprintIndex() {
        return this.workAssignment.getWorkSlot().getIndex();
    }

    @Override
    public double getWorkLoad() {
        return this.timeTransformer.getWorkInPlanningUnit(this.workAssignment.getAssignedWorkUnits());
    }

    @Override
    public String getStreamId() {
        return this.workAssignment.getProjectEpisode().getStreamId();
    }

    @Override
    public String getStageId() {
        return this.workAssignment.getProcessingStage().getId();
    }
}

