/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.InvalidSprintViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.MultiResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.ResourceSelectionAssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.AssignmentTransformationResult;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.ViolationDetector;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformationResult;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class AssignmentTransformer {
    private static final Log LOGGER = Log.with(AssignmentTransformer.class);
    private final ViolationDetector violationDetector;

    AssignmentTransformer(ViolationDetector violationDetector) {
        this.violationDetector = violationDetector;
    }

    AssignmentTransformer(SchedulingConfig schedulingConfig) {
        this(new ViolationDetector(schedulingConfig.getMaxResourcesPerStory()));
    }

    AssignmentTransformationResult tryTransformAssignment(SchedulingWorkItem workItem, TeamsTransformationResult teamTransformationResult, @Nullable IAggregatedWorkPackage workDemand) {
        LOGGER.debug("createAssignment for item: %s", workItem.getId());
        Optional<AssignmentRestriction> assignment = this.tryCreateAssignment(workItem, teamTransformationResult);
        HashSet violations = Sets.newHashSet();
        violations.addAll(this.getSprintViolations((AssignmentRestriction)assignment.orNull(), workItem));
        violations.addAll(this.getWorkViolations(workDemand, workItem, (AssignmentRestriction)assignment.orNull(), teamTransformationResult));
        return new AssignmentTransformationResult(violations, (AssignmentRestriction)assignment.orNull());
    }

    private Set<IScheduleViolation> getWorkViolations(@Nullable IAggregatedWorkPackage workDemand, SchedulingWorkItem workItem, @Nullable AssignmentRestriction assignment, TeamsTransformationResult teamTransformationResult) {
        Optional<IScheduleViolation> workViolation = this.violationDetector.tryFindViolation(workDemand, workItem, assignment, teamTransformationResult);
        if (workViolation.isPresent()) {
            return Sets.newHashSet((Object[])new IScheduleViolation[]{(IScheduleViolation)workViolation.get()});
        }
        return Sets.newHashSet();
    }

    private Set<IScheduleViolation> getSprintViolations(@Nullable AssignmentRestriction assignment, SchedulingWorkItem workItem) {
        if (assignment != null && workItem.getSprintId().isPresent() && !assignment.getWorkSlotIndex().isPresent()) {
            return Sets.newHashSet((Object[])new IScheduleViolation[]{new InvalidSprintViolation(workItem.getId())});
        }
        return Sets.newHashSet();
    }

    private Optional<AssignmentRestriction> tryCreateAssignment(SchedulingWorkItem workItem, TeamsTransformationResult teamTransformationResult) {
        Optional<String> assignedTeam = workItem.getTeamId();
        if (assignedTeam.isPresent()) {
            return this.tryCreateTeamAssigment(workItem, teamTransformationResult, (String)assignedTeam.get());
        }
        return this.createStreamRestriction(workItem, teamTransformationResult);
    }

    private Optional<AssignmentRestriction> createStreamRestriction(SchedulingWorkItem workItem, TeamsTransformationResult teamTransformationResult) {
        Set<String> restrictedStreamTeamIds = workItem.getStreamTeamRestrictions();
        Set<IResourceGroup> resourceGroups = teamTransformationResult.getResourceGroups();
        if (restrictedStreamTeamIds.isEmpty()) {
            MultiResourceGroupAssignment assignment = new MultiResourceGroupAssignment(resourceGroups);
            return Optional.of((Object)assignment);
        }
        Set<IResourceGroup> filteredResourceGroups = RmIdentifiableUtils.getElementsWithIds(restrictedStreamTeamIds, resourceGroups);
        MultiResourceGroupAssignment teamsAssignment = new MultiResourceGroupAssignment(filteredResourceGroups);
        return Optional.of((Object)teamsAssignment);
    }

    private Optional<AssignmentRestriction> tryCreateTeamAssigment(SchedulingWorkItem workItem, TeamsTransformationResult teamTransformationResult, String assignedTeam) {
        Optional<IResourceGroup> resourceGroup = teamTransformationResult.tryGetResourceGroup(assignedTeam);
        if (!resourceGroup.isPresent()) {
            return Optional.absent();
        }
        Set<String> resourceIds = workItem.getResources();
        Set<IWorkResource> assignedResources = this.getAssignedResources(((IResourceGroup)resourceGroup.get()).getResources(), resourceIds);
        if (!assignedResources.isEmpty()) {
            Optional<String> sprintId = workItem.getSprintId();
            if (sprintId.isPresent()) {
                Optional<IWorkSlot> workSlot = ((IResourceGroup)resourceGroup.get()).tryGetWorkSlotWithId((String)sprintId.get());
                if (!workSlot.isPresent()) {
                    return Optional.of((Object)new ResourceSelectionAssignmentRestriction((IResourceGroup)resourceGroup.get(), assignedResources));
                }
                return Optional.of((Object)new ResourceSelectionAssignmentRestriction((IResourceGroup)resourceGroup.get(), assignedResources, ((IWorkSlot)workSlot.get()).getIndex()));
            }
            ResourceSelectionAssignmentRestriction assignment = new ResourceSelectionAssignmentRestriction((IResourceGroup)resourceGroup.get(), assignedResources);
            return Optional.of((Object)assignment);
        }
        return Optional.absent();
    }

    private Set<IWorkResource> getAssignedResources(Set<IWorkResource> resources, Set<String> resourceIds) {
        if (resourceIds.isEmpty()) {
            return resources;
        }
        return RmIdentifiableUtils.getElementsWithIds(resourceIds, resources);
    }
}

