/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira;

import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.rm.common.envtestutils.ProjectDefinition;
import com.atlassian.rm.common.envtestutils.User;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestClassRule;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestMethodRule;
import com.atlassian.rm.common.envtestutils.WiredTestCase;
import com.atlassian.rm.common.envtestutils.WiredTestRuleFactory;
import com.atlassian.rm.common.envtestutils.WiredTestUtils;
import com.atlassian.rm.common.envtestutils.annotations.AgileRequirements;
import com.atlassian.rm.common.envtestutils.annotations.Login;
import com.atlassian.rm.common.envtestutils.annotations.Projects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionDataRequest;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseSyncResult;
import com.radiantminds.roadmap.common.extensions.releases.ReleasesExtensionData;
import com.radiantminds.roadmap.common.extensions.releases.VersionsBulkSyncRequest;
import com.radiantminds.roadmap.common.handlers.sync.releases.ValidReleaseSyncRequest;
import com.radiantminds.roadmap.common.handlers.sync.releases.VersionsBulkSyncRequestImpl;
import it.com.radiantminds.plugins.jira.testdata.InvisibleToNonAdminProject;
import it.com.radiantminds.plugins.jira.testdata.ReadOnlyToNonAdminProject;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class ReleaseExtensionTest
extends WiredTestCase {
    private static final String VERSION_NAME = "versionName";
    private static final String VERSION_DESCRIPTION = "versionDescription";
    private static final long START_INSTANT = 0L;
    private static final long RELEASE_INSTANT = 123234231234L;
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final ReleaseExtension releaseExtension;
    private final VersionManager versionManager;

    @Autowired
    public ReleaseExtensionTest(ReleaseExtension releaseExtension, VersionManager versionManager) {
        this.releaseExtension = releaseExtension;
        this.versionManager = versionManager;
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testNameUpdate() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        Version originalVersion = this.createDefaultVersion(project);
        VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.createNameUpdate(), null, null, "versionNameversionName");
        ReleaseSyncResult result = this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
        Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
        Version resultVersion = this.versionManager.getVersion(originalVersion.getId());
        Assert.assertEquals((Object)"versionNameversionName", (Object)resultVersion.getName());
        this.assertStart(resultVersion.getStartDate().getTime());
        this.assertRelease(resultVersion.getReleaseDate().getTime());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testNameUpdateNonAdmin() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        Version originalVersion = this.createDefaultVersion(project);
        VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.createNameUpdate(), null, null, "versionNameversionName");
        ReleaseSyncResult result = this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
        Assert.assertFalse((boolean)result.getViolationMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)result.getViolationMessages().size());
        Version resultVersion = this.versionManager.getVersion(originalVersion.getId());
        Assert.assertEquals((Object)originalVersion.getName(), (Object)resultVersion.getName());
        Assert.assertEquals((long)originalVersion.getStartDate().getTime(), (long)resultVersion.getStartDate().getTime());
        Assert.assertEquals((long)originalVersion.getReleaseDate().getTime(), (long)resultVersion.getReleaseDate().getTime());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testStartUpdate() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        Version originalVersion = this.createDefaultVersion(project);
        VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), this.createStartUpdate(), Long.valueOf(123234231234L), null, null);
        ReleaseSyncResult result = this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
        Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
        Version resultVersion = this.versionManager.getVersion(originalVersion.getId());
        Assert.assertEquals((Object)VERSION_NAME, (Object)resultVersion.getName());
        this.assertRelease(resultVersion.getStartDate().getTime());
        this.assertRelease(resultVersion.getReleaseDate().getTime());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testStartUpdateToNull() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        Version originalVersion = this.createDefaultVersion(project);
        VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), this.createStartUpdate(), null, null, null);
        ReleaseSyncResult result = this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
        Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
        Version resultVersion = this.versionManager.getVersion(originalVersion.getId());
        Assert.assertEquals((Object)VERSION_NAME, (Object)resultVersion.getName());
        Assert.assertNull((Object)resultVersion.getStartDate());
        this.assertRelease(resultVersion.getReleaseDate().getTime());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testEndUpdate() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        Version originalVersion = this.createDefaultVersion(project);
        VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), this.createReleaseUpdate(), null, Long.valueOf(1L), null);
        ReleaseSyncResult result = this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
        Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
        Version resultVersion = this.versionManager.getVersion(originalVersion.getId());
        Assert.assertEquals((Object)VERSION_NAME, (Object)resultVersion.getName());
        this.assertStart(resultVersion.getStartDate().getTime());
        this.assertStart(resultVersion.getReleaseDate().getTime());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testUpdateDuplicateVersionName() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        Version originalVersion = this.createDefaultVersion(project);
        VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.createNameUpdate(), null, null, "versionNameversionName");
        ReleaseSyncResult result = this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
        Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
        Version resultVersion = this.versionManager.getVersion(originalVersion.getId());
        Assert.assertEquals((Object)"versionNameversionName", (Object)resultVersion.getName());
        this.assertStart(resultVersion.getStartDate().getTime());
        this.assertRelease(resultVersion.getReleaseDate().getTime());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testReleaseUpdateToNull() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        Version originalVersion = this.createDefaultVersion(project);
        VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), this.createReleaseUpdate(), null, null, null);
        ReleaseSyncResult result = this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
        Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
        Version resultVersion = this.versionManager.getVersion(originalVersion.getId());
        Assert.assertEquals((Object)VERSION_NAME, (Object)resultVersion.getName());
        Assert.assertNull((Object)resultVersion.getReleaseDate());
        this.assertStart(resultVersion.getStartDate().getTime());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testNameUpdateWithDuplicateName() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        Version originalVersion = this.createDefaultVersion(project);
        Version blockingVersion = this.versionManager.createVersion("versionNameversionName", new Date(0L), new Date(123234231234L), VERSION_DESCRIPTION, project.getId(), null);
        VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.createNameUpdate(), null, null, blockingVersion.getName());
        ReleaseSyncResult result = this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
        Assert.assertEquals((long)1L, (long)result.getViolationMessages().size());
        Version resultVersion = this.versionManager.getVersion(originalVersion.getId());
        Assert.assertEquals((Object)VERSION_NAME, (Object)resultVersion.getName());
        this.assertStart(resultVersion.getStartDate().getTime());
        this.assertRelease(resultVersion.getReleaseDate().getTime());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testSuccessfulRetrieval() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        final Version originalVersion = this.createDefaultVersion(project);
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}));
            }
        };
        ReleasesExtensionData versions = this.releaseExtension.getReleasesExtensionData(request);
        ReleaseExtensionLinkData resultData = (ReleaseExtensionLinkData)versions.getEnrichtmentData().get(originalVersion.getId().toString());
        Assert.assertEquals((Object)"RETPDA", (Object)resultData.getProjectKey());
        Assert.assertEquals((Object)"RETPDA", (Object)resultData.getProjectName());
        Assert.assertEquals((Object)VERSION_DESCRIPTION, (Object)resultData.getVersionDescription());
        Assert.assertEquals((Object)VERSION_NAME, (Object)resultData.getVersionName());
        Assert.assertEquals((Object)originalVersion.getId().toString(), (Object)resultData.getLink());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testUnknownVersionId() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        this.createDefaultVersion(project);
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{"99999"}));
            }
        };
        ReleasesExtensionData versions = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertTrue((boolean)versions.getEnrichtmentData().isEmpty());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testStringLink() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        this.createDefaultVersion(project);
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{"lnk"}));
            }
        };
        ReleasesExtensionData versions = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertTrue((boolean)versions.getEnrichtmentData().isEmpty());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={ReleaseExtensionTestProjectDefinitionAdmin.class})
    public void testEmptyStringLinkSetIsOk() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(ReleaseExtensionTestProjectDefinitionAdmin.class);
        this.createDefaultVersion(project);
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet());
            }
        };
        ReleasesExtensionData versions = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertTrue((boolean)versions.getEnrichtmentData().isEmpty());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @AgileRequirements(installed=true)
    @Projects(value={InvisibleToNonAdminProject.class})
    public void testNonAdminGetsNoVersionInformation() throws Exception {
        final Project project = this.wiredIntegrationTestRule.getProject(InvisibleToNonAdminProject.class);
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{ReleaseExtensionTest.this.getVersionId(project.getVersions())}));
            }
        };
        ReleasesExtensionData data = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertTrue((boolean)data.getEnrichtmentData().isEmpty());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={InvisibleToNonAdminProject.class})
    public void testAdminGetsVersionInformation() throws Exception {
        final Project project = this.wiredIntegrationTestRule.getProject(InvisibleToNonAdminProject.class);
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{ReleaseExtensionTest.this.getVersionId(project.getVersions())}));
            }
        };
        ReleasesExtensionData data = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertEquals((long)1L, (long)data.getEnrichtmentData().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @Projects(value={ReadOnlyToNonAdminProject.class})
    public void testNonAdminGetsNoVersionInformationForReadOnlyProject() throws Exception {
        final Project project = this.wiredIntegrationTestRule.getProject(ReadOnlyToNonAdminProject.class);
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{ReleaseExtensionTest.this.getVersionId(project.getVersions())}));
            }
        };
        ReleasesExtensionData data = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertEquals((long)1L, (long)data.getEnrichtmentData().size());
    }

    private Version createDefaultVersion(Project project) throws CreateException {
        return this.versionManager.createVersion(VERSION_NAME, new Date(0L), new Date(123234231234L), VERSION_DESCRIPTION, project.getId(), null);
    }

    private static ValidReleaseSyncRequest createNameUpdate() {
        ValidReleaseSyncRequest mock = (ValidReleaseSyncRequest)Mockito.mock(ValidReleaseSyncRequest.class);
        Mockito.when((Object)mock.isSyncName()).thenReturn((Object)true);
        return mock;
    }

    private ValidReleaseSyncRequest createStartUpdate() {
        ValidReleaseSyncRequest mock = (ValidReleaseSyncRequest)Mockito.mock(ValidReleaseSyncRequest.class);
        Mockito.when((Object)mock.isSyncStartDate()).thenReturn((Object)true);
        return mock;
    }

    private ValidReleaseSyncRequest createReleaseUpdate() {
        ValidReleaseSyncRequest mock = (ValidReleaseSyncRequest)Mockito.mock(ValidReleaseSyncRequest.class);
        Mockito.when((Object)mock.isSyncReleaseDate()).thenReturn((Object)true);
        return mock;
    }

    private void assertRelease(long time) {
        Assert.assertTrue((time > 61617115617L ? 1 : 0) != 0);
    }

    private void assertStart(long time) {
        Assert.assertTrue((time < 61617115617L ? 1 : 0) != 0);
    }

    private String getVersionId(Collection<Version> versions) {
        Version version = (Version)Iterables.getLast(versions);
        return version.getId().toString();
    }

    private static class ReleaseExtensionTestProjectDefinitionAdmin
    implements ProjectDefinition {
        public static final String PROJECT_KEY = "RETPDA";

        private ReleaseExtensionTestProjectDefinitionAdmin() {
        }

        public Project instantiate(WiredTestUtils utils) throws Exception {
            return utils.getProjectUtils().createStandardProject(utils.getUserUtils().getAdminUser(), PROJECT_KEY, PROJECT_KEY);
        }
    }
}

