/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SoftwareVersion
implements Comparable<SoftwareVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.?(-.*|\\d+)?\\.?(-.*)?");
    private final int majorVersion;
    private final int minorVersion;
    private final int bugFixVersion;
    private final String qualifier;
    private final String versionString;

    public SoftwareVersion(String version) {
        this.versionString = version;
        Matcher versionMatcher = VERSION_PATTERN.matcher(this.versionString);
        if (versionMatcher.find()) {
            this.majorVersion = this.decode(versionMatcher, 1, 0);
            this.minorVersion = this.decode(versionMatcher, 2, 0);
            String group3 = versionMatcher.group(3);
            if (group3 != null && !group3.contains("-")) {
                this.bugFixVersion = this.decode(versionMatcher, 3, 0);
                this.qualifier = this.getOrElse(versionMatcher, 4, "").replaceFirst("-", "");
            } else {
                this.bugFixVersion = 0;
                this.qualifier = this.getOrElse(versionMatcher, 3, "").replaceFirst("-", "");
            }
        } else {
            throw new IllegalArgumentException("The version string is not in the expected format");
        }
    }

    public SoftwareVersion(int majorVersion, int minorVersion, int bugfixVersion, String qualifier) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.bugFixVersion = bugfixVersion;
        this.qualifier = qualifier;
        this.versionString = String.format("%d.%d.%d-%s", majorVersion, minorVersion, bugfixVersion, qualifier);
    }

    public SoftwareVersion(int majorVersion, int minorVersion, int bugfixVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.bugFixVersion = bugfixVersion;
        this.qualifier = "";
        this.versionString = String.format("%d.%d.%d", majorVersion, minorVersion, bugfixVersion);
    }

    public SoftwareVersion(int majorVersion, int minorVersion, String qualifier) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.bugFixVersion = 0;
        this.qualifier = qualifier;
        this.versionString = String.format("%d.%d-%s", majorVersion, minorVersion, qualifier);
    }

    public SoftwareVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.bugFixVersion = 0;
        this.qualifier = "";
        this.versionString = String.format("%d.%d", majorVersion, minorVersion);
    }

    private int decode(Matcher versionMatcher, int i, int defaultVal) {
        if (versionMatcher.group(i) != null) {
            return Integer.decode(versionMatcher.group(i));
        }
        return defaultVal;
    }

    private String getOrElse(Matcher versionMatcher, int i, String defaultVal) {
        if (versionMatcher.group(i) != null) {
            return versionMatcher.group(i);
        }
        return defaultVal;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getBugFixVersion() {
        return this.bugFixVersion;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean isGreaterThanOrEqualTo(SoftwareVersion that) {
        return this.compareTo(that) >= 0;
    }

    public boolean isLessThanOrEqualTo(SoftwareVersion that) {
        return this.compareTo(that) <= 0;
    }

    public boolean isGreaterThan(SoftwareVersion that) {
        return this.compareTo(that) > 0;
    }

    public boolean isLessThan(SoftwareVersion that) {
        return this.compareTo(that) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftwareVersion that = (SoftwareVersion)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result = this.majorVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + this.bugFixVersion;
        result = 31 * result + this.qualifier.hashCode();
        return result;
    }

    public String toString() {
        return this.versionString;
    }

    @Override
    public int compareTo(SoftwareVersion that) {
        if (this.majorVersion < that.majorVersion) {
            return -1;
        }
        if (this.majorVersion > that.majorVersion) {
            return 1;
        }
        if (this.minorVersion < that.minorVersion) {
            return -1;
        }
        if (this.minorVersion > that.minorVersion) {
            return 1;
        }
        if (this.bugFixVersion < that.bugFixVersion) {
            return -1;
        }
        if (this.bugFixVersion > that.bugFixVersion) {
            return 1;
        }
        if (StringUtils.isEmpty((String)this.qualifier) && !StringUtils.isEmpty((String)that.qualifier)) {
            return 1;
        }
        if (!StringUtils.isEmpty((String)this.qualifier) && StringUtils.isEmpty((String)that.qualifier)) {
            return -1;
        }
        return this.qualifier.compareTo(that.qualifier);
    }
}

