/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.EligibleEntry;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.FreedWorkCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IMutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IUnstructuredItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IMutableDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.StepFunctionTroveListImpl;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class EligibleWorkTracker {
    final IAggregatedWorkPackage inputPackage;
    final int upperTimeBound;
    final boolean stageTransitionEnforced;
    private final FreedWorkCalculator freedWorkCalculator;
    final Map<IProcessingStage, IMutableDiscreteStepFunction> eligibleWorkFunctions;

    EligibleWorkTracker(Map<IProcessingStage, IMutableDiscreteStepFunction> eligibleWorkFunctions, IAggregatedWorkPackage inputPackage, int upperTimeBound, boolean stageTransitionEnforced, FreedWorkCalculator freedWorkCalculator) {
        this.eligibleWorkFunctions = eligibleWorkFunctions;
        this.inputPackage = inputPackage;
        this.upperTimeBound = upperTimeBound;
        this.stageTransitionEnforced = stageTransitionEnforced;
        this.freedWorkCalculator = freedWorkCalculator;
    }

    Optional<EligibleEntry> getTimeStepForEligible(float minimumValue, IProcessingStage stage) {
        IMutableDiscreteStepFunction eligibilityFunction = this.eligibleWorkFunctions.get(stage);
        Optional<Integer> eligibleTimeStep = eligibilityFunction.getXWhereYGeq(minimumValue, 0);
        if (!eligibleTimeStep.isPresent()) {
            return Optional.absent();
        }
        float amount = eligibilityFunction.getAt((Integer)eligibleTimeStep.get());
        EligibleEntry entry = new EligibleEntry((Integer)eligibleTimeStep.get(), amount);
        return Optional.of((Object)entry);
    }

    Optional<Integer> updateAndGetFreedTimeStep(IProcessingStageWorkPackage doneWork, IIntegerInterval workInterval, IMutableAggregatedWorkPackage openPackage) {
        IProcessingStage doneStage = doneWork.getProcessingStage();
        float doneAmount = doneWork.getAmount();
        IMutableDiscreteStepFunction eligibilityFunction = this.eligibleWorkFunctions.get(doneStage);
        eligibilityFunction.add(new IntegerInterval(0, this.upperTimeBound), -doneAmount);
        Optional<Map.Entry<IProcessingStage, Float>> nextStage = this.freedWorkCalculator.calculateFreedForStage(doneStage, doneAmount, openPackage);
        if (nextStage.isPresent()) {
            float freedForStage = ((Float)((Map.Entry)nextStage.get()).getValue()).floatValue();
            IProcessingStage freedStage = (IProcessingStage)((Map.Entry)nextStage.get()).getKey();
            IMutableDiscreteStepFunction freeEligibilityFunction = this.eligibleWorkFunctions.get(freedStage);
            int freedTimeStep = this.calculateFreedTimeStep(workInterval);
            freeEligibilityFunction.add(new IntegerInterval(freedTimeStep, this.upperTimeBound), freedForStage);
            return Optional.of((Object)freedTimeStep);
        }
        return Optional.absent();
    }

    private int calculateFreedTimeStep(IIntegerInterval workInterval) {
        int end = workInterval.getEnd();
        if (this.stageTransitionEnforced) {
            return end + 1;
        }
        return workInterval.getStart();
    }

    static EligibleWorkTracker createInstance(IUnstructuredItemSchedulingProblem problem) {
        HashMap functions = Maps.newHashMap();
        List<IProcessingStage> specifiedStages = problem.getWorkDemand().getSpecifiedStages();
        IProcessingStage firstStage = specifiedStages.get(0);
        float firstStageDemand = ((IProcessingStageWorkPackage)problem.getWorkDemand().getWorkPackageForStage(firstStage).get()).getAmount();
        StepFunctionTroveListImpl firstFunction = new StepFunctionTroveListImpl(firstStageDemand);
        IntegerInterval offset = new IntegerInterval(0, problem.getLowerTimeBound() - 1);
        if (offset.getLength() > 0) {
            firstFunction.add(offset, -firstStageDemand);
        }
        functions.put(firstStage, firstFunction);
        for (int i = 1; i < specifiedStages.size(); ++i) {
            functions.put(specifiedStages.get(i), new StepFunctionTroveListImpl(0.0f));
        }
        EligibleWorkTracker instance = new EligibleWorkTracker(functions, problem.getWorkDemand(), problem.getUpperTimeBound(), problem.isStageTransitionEnforced(), FreedWorkCalculator.createInstance(problem.getWorkDemand()));
        return instance;
    }
}

