/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.apache;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IResourceToTypeWeightVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.apache.IApacheUnstructuredObjectiveCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.BalancedStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;

class ApacheUnstructObjectiveCreator
implements IApacheUnstructuredObjectiveCreator {
    static final float WORK_OFFSET = 1.0f;
    static final float SKILL_DISTRIBUTION_FACTOR = 0.0f;

    ApacheUnstructObjectiveCreator() {
    }

    @Override
    public LinearObjectiveFunction createObjectiveFunction(BalancedStageLpProblem problem) {
        PrimitivesMap<IMutableResource> resourceCost = problem.getResourceCost();
        float workCoefficient = this.calculateWorkCoefficient(resourceCost);
        List<IResourceToTypeWeightVariable> variables = problem.getAssignmentVariables();
        int varCount = problem.getVariableCount();
        double[] coefficients = new double[varCount];
        for (int i = 0; i < variables.size(); ++i) {
            IResourceToTypeWeightVariable variable = variables.get(i);
            IMutableResource resource = variable.getMutableResource();
            float f = resourceCost.get(resource);
            coefficients[i] = workCoefficient - f;
        }
        float skillDistributionCoefficient = this.calculateSkillDistribution(resourceCost);
        Map<List<IResourceType>, int[]> map = problem.getBalanceVarMap();
        for (Map.Entry entry : map.entrySet()) {
            int[] indices = (int[])entry.getValue();
            coefficients[indices[1]] = -skillDistributionCoefficient;
            coefficients[indices[2]] = -skillDistributionCoefficient;
        }
        LinearObjectiveFunction objectiveFunction = new LinearObjectiveFunction(coefficients, 0.0);
        return objectiveFunction;
    }

    private float calculateSkillDistribution(PrimitivesMap<IMutableResource> resourceCost) {
        return resourceCost.getMinValue() * 0.0f;
    }

    private float calculateWorkCoefficient(PrimitivesMap<IMutableResource> resourceCost) {
        return resourceCost.getMaxValue() + 1.0f;
    }
}

