/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.AnnotatedResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.DependencyIgnoredEpisodeWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.GraphBasedDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.jgrapht.Graphs;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;

@Immutable
public class DependencyDefinitionFactory {
    private static final Log LOGGER = Log.with(DependencyDefinitionFactory.class);

    public AnnotatedResult<IDependencyDefinition> createInstance(DirectedAcyclicGraph<IProcessingItem, DefaultEdge> dependencyGraph, ITimePlan timePlan) {
        Preconditions.checkNotNull(dependencyGraph);
        Preconditions.checkNotNull((Object)timePlan);
        LOGGER.debug("create dependency definition", new Object[0]);
        AnnotatedResult.Builder<GraphBasedDependencyDefinition> depencyDefinition = new AnnotatedResult.Builder<GraphBasedDependencyDefinition>();
        Set<DefaultEdge> ignoredEdges = DependencyDefinitionFactory.getIgnoredEdges(dependencyGraph, timePlan);
        for (DefaultEdge ignoredEdge : ignoredEdges) {
            LOGGER.debug("add warning for ignored dependency: %s", dependencyGraph.getEdgeTarget(ignoredEdge));
            depencyDefinition.addWarning(new DependencyIgnoredEpisodeWarning(((IProcessingItem)dependencyGraph.getEdgeTarget(ignoredEdge)).getId()));
        }
        dependencyGraph.removeAllEdges(ignoredEdges);
        AnnotatedResult<IDependencyDefinition> result = depencyDefinition.build(new GraphBasedDependencyDefinition(dependencyGraph));
        LOGGER.debug("created dependency definition: %s", result);
        return result;
    }

    private static Set<DefaultEdge> getIgnoredEdges(DirectedAcyclicGraph<IProcessingItem, DefaultEdge> schedulingDependencyGraph, ITimePlan timePlan) {
        LOGGER.debug("find causal dependencies to be ignored", new Object[0]);
        List<IProcessingItem> sortedItems = DependencyDefinitionFactory.sortProcessingItems(schedulingDependencyGraph);
        DirectedAcyclicGraph<IProcessingItem, DefaultEdge> timePlanAndDependenciesGraph = DependencyDefinitionFactory.createTimePlanBasedDependencyGraph(schedulingDependencyGraph, timePlan, sortedItems);
        HashSet ignoredEdges = Sets.newHashSet();
        for (IProcessingItem item : sortedItems) {
            for (DefaultEdge edge : schedulingDependencyGraph.incomingEdgesOf(item)) {
                try {
                    timePlanAndDependenciesGraph.addDagEdge((IProcessingItem)schedulingDependencyGraph.getEdgeSource(edge), (IProcessingItem)schedulingDependencyGraph.getEdgeTarget(edge));
                }
                catch (DirectedAcyclicGraph.CycleFoundException e) {
                    LOGGER.debug("edge is ignored because of cyclic dependency: %s", edge);
                    ignoredEdges.add(edge);
                }
            }
        }
        return ignoredEdges;
    }

    private static DirectedAcyclicGraph<IProcessingItem, DefaultEdge> createTimePlanBasedDependencyGraph(SimpleDirectedGraph<IProcessingItem, DefaultEdge> schedulingDependencyGraph, ITimePlan timePlan, List<IProcessingItem> sortedItems) {
        DirectedAcyclicGraph<IProcessingItem, DefaultEdge> timePlanAndDependenciesGraph = new DirectedAcyclicGraph<IProcessingItem, DefaultEdge>(DefaultEdge.class);
        Graphs.addAllVertices(timePlanAndDependenciesGraph, schedulingDependencyGraph.vertexSet());
        for (IProcessingItem item1 : sortedItems) {
            for (IProcessingItem item2 : sortedItems) {
                if (!DependencyDefinitionFactory.isStrictlyReleasedBefore(item1, item2, timePlan)) continue;
                try {
                    timePlanAndDependenciesGraph.addDagEdge(item1, item2);
                }
                catch (DirectedAcyclicGraph.CycleFoundException e) {
                    LOGGER.error("found cyclic dependencies in releases", new Object[0]);
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return timePlanAndDependenciesGraph;
    }

    private static List<IProcessingItem> sortProcessingItems(final SimpleDirectedGraph<IProcessingItem, DefaultEdge> schedulingDependencyGraph) {
        ArrayList sortedItems = Lists.newArrayList(schedulingDependencyGraph.vertexSet());
        Collections.sort(sortedItems, new Comparator<IProcessingItem>(){

            @Override
            public int compare(IProcessingItem o1, IProcessingItem o2) {
                int inDegreeValue = Ints.compare((int)schedulingDependencyGraph.inDegreeOf(o1), (int)schedulingDependencyGraph.inDegreeOf(o2));
                if (inDegreeValue != 0) {
                    return inDegreeValue;
                }
                return RmSortableUtils.COMPARATOR.compare(o1, o2);
            }
        });
        return sortedItems;
    }

    private static boolean isStrictlyReleasedBefore(IProcessingItem item1, IProcessingItem item2, ITimePlan timePlan) {
        String fixedEpisode1 = (String)item1.getFixedEpisodeId().orNull();
        if (fixedEpisode1 == null) {
            return false;
        }
        String fixedEpisode2 = (String)item2.getFixedEpisodeId().orNull();
        if (fixedEpisode2 == null) {
            return false;
        }
        return timePlan.isEpisodeStrictlyBefore(fixedEpisode1, fixedEpisode2);
    }
}

