/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.HasIndex;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.SortedPositivePrimitiveMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.Relationship;

public abstract class ApacheUtils {
    public static <T> List<LinearConstraint> createOrderedLinearConstraints(Map<T, Set<Integer>> indicesMap, SortedPositivePrimitiveMap<T> limitsMap, int varCount, Relationship relationship) {
        return ApacheUtils.createLinearConstraints(indicesMap, limitsMap, varCount, relationship);
    }

    private static <T> List<LinearConstraint> createLinearConstraints(Map<T, Set<Integer>> indicesMap, SortedPositivePrimitiveMap<T> limitsMap, int varCount, Relationship relationship) {
        ArrayList constraints = Lists.newArrayList();
        for (Object key : limitsMap.keySet()) {
            Set<Integer> indices = indicesMap.get(key);
            if (indices == null) continue;
            double[] coefficients = ApacheUtils.createOneCoefficients(indices, varCount);
            float value = limitsMap.get(key);
            LinearConstraint constraint = new LinearConstraint(coefficients, relationship, (double)value);
            constraints.add(constraint);
        }
        return constraints;
    }

    public static <K> Set<LinearConstraint> createLinearConstraintsForLimits(Map<K, Set<Integer>> indicesMap, PositivePrimitivesMap<K> limitsMap, int varCount, Relationship relationship) {
        HashSet constraints = Sets.newHashSet();
        for (K key : limitsMap.keySet()) {
            HashSet indices = indicesMap.get(key);
            if (indices == null) {
                indices = Sets.newHashSet();
            }
            double[] coefficients = ApacheUtils.createOneCoefficients(indices, varCount);
            float value = limitsMap.get(key);
            LinearConstraint constraint = new LinearConstraint(coefficients, relationship, (double)value);
            constraints.add(constraint);
        }
        return constraints;
    }

    public static double[] createOneCoefficients(Set<Integer> oneIndices, int varCount) {
        double[] coefficients = new double[varCount];
        for (int index : oneIndices) {
            coefficients[index] = 1.0;
        }
        return coefficients;
    }

    public static double[] createSetCoefficients(Set<? extends HasIndex> setIndices, int varCount) {
        double[] coefficients = new double[varCount];
        for (HasIndex hasIndex : setIndices) {
            coefficients[hasIndex.getIndex()] = 1.0;
        }
        return coefficients;
    }
}

