/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.teams;

import com.radiantminds.roadmap.common.data.generator.teams.IPresenceConfiguration;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PresenceConfiguration
implements IPresenceConfiguration {
    private final Long startInstant;
    private final Long endInstant;

    public PresenceConfiguration(Integer daysFromNowStart, Integer daysFromNowEnd) {
        this.startInstant = this.getInstant(daysFromNowStart);
        this.endInstant = this.getInstant(daysFromNowEnd);
    }

    private Long getInstant(Integer days) {
        if (days == null) {
            return null;
        }
        DateTime now = new DateTime(DateTimeZone.UTC);
        DateTime plusDays = now.plusDays(days.intValue());
        return plusDays.getMillis();
    }

    @Override
    public Long getStartDate() {
        return this.startInstant;
    }

    @Override
    public Long getEndDate() {
        return this.endInstant;
    }
}

