/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.time;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.generator.time.IReleaseConfiguration;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.rest.entities.releases.RestRelease;
import javax.annotation.concurrent.Immutable;

@Immutable
class ReleasePersistency {
    private final PortfolioReleasePersistence releasePersistence;

    ReleasePersistency(PortfolioReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
    }

    public IRelease persistRelease(IReleaseConfiguration configuration, IStream stream, int index, IPlan plan) throws PersistenceException {
        Optional<String> primaryVersion;
        Optional<Long> delta;
        Optional<Long> endDate;
        RestRelease release = new RestRelease(null, null, null, null, null, null, null);
        String title = configuration.getTitle();
        release.setTitle(title);
        Optional<Long> startDate = configuration.getStartDate();
        if (startDate.isPresent()) {
            release.setFixedStartDate((Long)startDate.get());
        }
        if ((endDate = configuration.getEndDate()).isPresent()) {
            release.setFixedEndDate((Long)endDate.get());
        }
        if ((delta = configuration.getDelta()).isPresent()) {
            release.setDeltaStartDate((Long)delta.get());
        }
        if ((primaryVersion = configuration.getPrimaryVersion()).isPresent()) {
            release.setPrimaryVersion((String)primaryVersion.get());
        }
        release.setSortOrder(Long.valueOf(index));
        release.setStream(stream);
        IRelease persistedRelease = this.releasePersistence.persist(release);
        return persistedRelease;
    }
}

