/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsAccessorImpl;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilitiesImpl;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.PortfolioActiveObjectsExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.PortfolioActiveObjectsPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.PortfolioActiveObjectsResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.PortfolioActiveObjectsTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.PortfolioActiveObjectsPlanPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.PortfolioActiveObjectsStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.PortfolioActiveObjectsEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.PortfolioActiveObjectsWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.util.List;
import java.util.Map;

public class UpgradePersistenceIndex
implements PersistenceIndex {
    private final ActiveObjectsUtilities utils;
    private final Map<Class<?>, IEntityPersistence> persistenceMap;
    private final Map<Class<?>, Object> beanMap;

    public UpgradePersistenceIndex(ActiveObjects ao) {
        ActiveObjectsAccessorImpl accessor = new ActiveObjectsAccessorImpl(ao);
        this.utils = new ActiveObjectsUtilitiesImpl(accessor, this);
        PortfolioActiveObjectsPlanPersistence planPersistence = new PortfolioActiveObjectsPlanPersistence(this, this.utils);
        PortfolioActiveObjectsTeamPersistence teamPersistence = new PortfolioActiveObjectsTeamPersistence(this, this.utils, planPersistence, null);
        PortfolioActiveObjectsPersonPersistence personPersistence = new PortfolioActiveObjectsPersonPersistence(this.utils, planPersistence, null);
        PortfolioActiveObjectsResourcePersistence resourcePersistence = new PortfolioActiveObjectsResourcePersistence(this.utils, personPersistence, teamPersistence, null);
        PortfolioActiveObjectsEstimatePersistence estimatePersistence = new PortfolioActiveObjectsEstimatePersistence(this.utils);
        PortfolioActiveObjectsWorkItemPersistence workItemPersistence = new PortfolioActiveObjectsWorkItemPersistence(this.utils, planPersistence, resourcePersistence, estimatePersistence, null);
        PortfolioActiveObjectsStreamPersistence streamPersistence = new PortfolioActiveObjectsStreamPersistence(this, this.utils, planPersistence);
        PortfolioActiveObjectsExtensionLinkPersistence extensionLinkPersistence = new PortfolioActiveObjectsExtensionLinkPersistence(this.utils);
        this.persistenceMap = Maps.newHashMap();
        this.persistenceMap.put(PortfolioStreamPersistence.class, streamPersistence);
        this.persistenceMap.put(PortfolioTeamPersistence.class, teamPersistence);
        this.persistenceMap.put(PortfolioWorkItemPersistence.class, workItemPersistence);
        this.persistenceMap.put(PortfolioPlanPersistence.class, planPersistence);
        this.persistenceMap.put(PortfolioExtensionLinkPersistence.class, extensionLinkPersistence);
        this.beanMap = Maps.newHashMap();
    }

    @Override
    public List<IEntityPersistence> getPersistenceBeans() {
        return Lists.newArrayList(this.persistenceMap.values());
    }

    @Override
    public <T> T getBeanFromContext(Class<T> persistenceClazz) {
        return (T)this.beanMap.get(persistenceClazz);
    }

    @Override
    public ActiveObjectsUtilities getPersistenceUtilityBean() {
        return this.utils;
    }
}

