/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.rest.entities.scheduling.BaseErrorAwareSolution;
import com.radiantminds.roadmap.common.rest.entities.scheduling.ResourceStageIntervals;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSolutionInterval;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.Interval;

@XmlRootElement(name="workItem")
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class BaseRestWorkItemSolution
extends BaseErrorAwareSolution {
    @XmlElement
    private String id;
    @XmlElement
    private Set<String> resources;
    @XmlElement
    private Long start;
    @XmlElement
    private Long end;
    @XmlElement
    private Set<ResourceStageIntervals> resourceStageIntervals;

    @Deprecated
    protected BaseRestWorkItemSolution() {
    }

    protected BaseRestWorkItemSolution(String id, Set<String> resources, Long start, Long end, Set<ResourceStageIntervals> resourceStageIntervals) {
        this.id = id;
        this.resources = resources;
        this.start = start;
        this.end = end;
        this.resourceStageIntervals = resourceStageIntervals;
    }

    protected static List<IntervalsEntry> parseIntervalMap(Map<String, Map<String, Map<String, Set<Interval>>>> intervalsMap, String id) {
        ArrayList retVal = Lists.newArrayList();
        Map<String, Map<String, Set<Interval>>> itemToStageMap = intervalsMap.get(id);
        if (itemToStageMap != null) {
            for (String itemId : itemToStageMap.keySet()) {
                Map<String, Set<Interval>> stageMap = itemToStageMap.get(itemId);
                if (stageMap == null) continue;
                HashSet stageIntervals = Sets.newHashSet();
                for (String stageId : stageMap.keySet()) {
                    Set<Interval> intervalsForThisStage = stageMap.get(stageId);
                    if (intervalsForThisStage == null) continue;
                    for (Interval interval : intervalsForThisStage) {
                        stageIntervals.add(new RestSolutionInterval(stageId, interval));
                    }
                }
                retVal.add(new IntervalsEntry(itemId, stageIntervals));
            }
        }
        return retVal;
    }

    protected static class IntervalsEntry {
        private final String id;
        private final Set<RestSolutionInterval> intervals;

        public IntervalsEntry(String id, Set<RestSolutionInterval> intervals) {
            this.id = id;
            this.intervals = intervals;
        }

        public String getId() {
            return this.id;
        }

        public Set<RestSolutionInterval> getIntervals() {
            return this.intervals;
        }
    }
}

