/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.Interval;

@XmlRootElement(name="interval")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestSolutionInterval {
    @XmlElement
    private String id;
    @XmlElement
    private Long start;
    @XmlElement
    private Long end;

    protected RestSolutionInterval() {
    }

    public RestSolutionInterval(String id) {
        this.id = id;
    }

    private RestSolutionInterval(String id, Long start, Long end) {
        this.id = id;
        this.start = start;
        this.end = end;
    }

    public RestSolutionInterval(String id, Interval interval) {
        this(id);
        this.setInterval(interval);
    }

    protected void setInterval(Interval interval) {
        if (interval != null) {
            this.start = interval.getStartMillis();
            this.end = interval.getEndMillis();
        }
    }

    public void setInterval(Long start, Long end) {
        this.start = start;
        this.end = end;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public static RestSolutionInterval create(SchedulingInterval interval) {
        return new RestSolutionInterval(null, interval.getStartDate(), interval.getEndDate());
    }
}

