/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.streams;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.releases.RestRelease;
import com.radiantminds.roadmap.common.rest.entities.releases.RestStream;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.streams.StreamServiceHandler;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/streams")
@Component
public class StreamService
extends BaseOperationsService<IStream, RestStream> {
    private final StreamServiceHandler handler;
    private final PortfolioStreamPersistence streamPersistence;

    @Autowired
    public StreamService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioWorkItemPersistence workItemPersistence, PortfolioStreamPersistence streamPersistence, PortfolioReleasePersistence releasePersistence) {
        super(RestStream.class, streamPersistence, handlerFactory);
        this.streamPersistence = streamPersistence;
        this.handler = handlerFactory.createProxy(StreamServiceHandler.class, new StreamServiceHandler.Impl(activeObjectsUtilities, releasePersistence, streamPersistence, workItemPersistence), streamPersistence);
    }

    @Override
    protected RestStream transform(IStream entity, boolean includeReplanningData) {
        try {
            return new RestStream(entity, this.streamPersistence);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to transform IStream to RestStream.", ex);
        }
    }

    @Override
    protected Response update(RestStream source, IStream target, boolean allowNull) {
        this.updateCommons(source, target, allowNull);
        if (allowNull || source.getColor() != null) {
            target.setColor(source.getColor());
        }
        if (allowNull || source.getShortName() != null) {
            target.setShortName(source.getShortName());
        }
        return null;
    }

    @Override
    @Path(value="{id}/deprecated")
    public Response entryDelete(@PathParam(value="id") String id, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return ResponseBuilder.notFound();
    }

    @DELETE
    @Path(value="{id}")
    public Response entryDelete(@PathParam(value="id") String id, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="moveTo") String alternateStreamId, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.entryDelete(EntityContext.from(id, version, expectedPlanVersion, clientId), alternateStreamId);
    }

    @GET
    @Path(value="{id}/releases/later")
    public Response getLaterRelease(@PathParam(value="id") String streamId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getLaterRelease(EntityContext.from(streamId, expectedPlanVersion));
    }

    @GET
    @Path(value="{id}/releases")
    public Response getAllReleases(@PathParam(value="id") String streamId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllReleases(EntityContext.from(streamId, expectedPlanVersion));
    }

    @POST
    @Path(value="{id}/releases")
    public Response addReleaseToStream(@PathParam(value="id") String streamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRelease newRelease) throws Exception {
        return this.handler.addReleaseToStream(EntityContext.from(streamId, expectedPlanVersion, clientId), newRelease);
    }

    @PUT
    @Path(value="{id}/releases/rank")
    public Response rankRelease(@PathParam(value="id") String streamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankRelease(EntityContext.from(streamId, expectedPlanVersion, clientId), rank);
    }
}

