/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.streams.teams;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.releases.RestStreamTeamAssignment;
import com.radiantminds.roadmap.common.rest.services.streams.teams.StreamTeamAssignmentRequest;
import com.radiantminds.roadmap.common.rest.services.streams.teams.StreamTeamAssignmentServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/streams/{id}/assignment")
@Component
public class StreamTeamAssignmentService {
    private final StreamTeamAssignmentServiceHandler handler;

    @Autowired
    public StreamTeamAssignmentService(PersistenceIndex persistenceIndex, SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioTeamPersistence teamPersistence, PortfolioStreamPersistence streamPersistence) {
        this(handlerFactory.createProxy(StreamTeamAssignmentServiceHandler.class, new StreamTeamAssignmentServiceHandler.Impl(persistenceIndex, activeObjectsUtilities, teamPersistence), streamPersistence));
    }

    StreamTeamAssignmentService(StreamTeamAssignmentServiceHandler handler) {
        this.handler = handler;
    }

    @PUT
    public Response setAssignment(@PathParam(value="id") String streamId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="version") Long expectedEntityVersion, @QueryParam(value="clientId") String clientId, RestStreamTeamAssignment assignment) throws Exception {
        Response retVal = this.handler.handleRequest(EntityContext.from(streamId, expectedEntityVersion, expectedPlanVersion, clientId), StreamTeamAssignmentRequest.createNullSafe(assignment.getTeamIds()));
        return retVal;
    }
}

